/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CyclicBarrier;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.frame.RtFrameStack;
import se.prediktera.breeze.common.util.thread.BreezeThread;

public class RtPredictWorkers {
    private final RtFramePredictor predictor;
    private final CyclicBarrier startBarrier;
    private final CyclicBarrier finishBarrier;
    private Frame frame;
    private RtFrameStack frameStack;
    private boolean working = true;
    private final ConcurrentLinkedQueue<Integer> blockQueue = new ConcurrentLinkedQueue();

    public RtPredictWorkers(RtFramePredictor rtFramePredictor, int n) {
        this.predictor = rtFramePredictor;
        this.startBarrier = new CyclicBarrier(n);
        this.finishBarrier = new CyclicBarrier(n);
        for (int i = 1; i < n; ++i) {
            new BreezeThread("PredictWorker:" + i, () -> {
                while (this.working) {
                    this.apply();
                }
            }).start();
        }
    }

    public final void apply(Frame frame, RtFrameStack rtFrameStack) {
        this.frame = frame;
        this.frameStack = rtFrameStack;
        for (int i = 0; i < this.predictor.getBlocks(); ++i) {
            this.blockQueue.add(i);
        }
        this.apply();
    }

    private void apply() {
        try {
            Integer n;
            this.startBarrier.await();
            while ((n = this.blockQueue.poll()) != null) {
                this.predictor.applyBlock(this.frame, this.frameStack, n);
            }
            this.finishBarrier.await();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (BrokenBarrierException brokenBarrierException) {
            // empty catch block
        }
    }

    public void stop() {
        this.working = false;
        this.startBarrier.reset();
        this.finishBarrier.reset();
    }
}

