/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.realtime.frame.RtFrame;

public class ValueCorrectionPixels {
    public static int W = 0;
    public static int P = 1;
    private int[] resetIndex;
    private int[] index;
    private int[][][] point;
    private int[][] neighbours;
    private int[] incIdxArray;
    public int[][] saturated;
    public final boolean applyValueCorrection;

    public ValueCorrectionPixels(RtFrame rtFrame) {
        this(rtFrame, true);
    }

    public ValueCorrectionPixels(RtFrame rtFrame, boolean bl) {
        this.applyValueCorrection = bl;
        this.initiate(rtFrame, null);
    }

    public void initiate(RtFrame rtFrame, int[] nArray) {
        int n;
        this.incIdxArray = nArray;
        this.point = new int[rtFrame.blocks][][];
        this.saturated = new int[rtFrame.blocks][];
        for (n = 0; n < rtFrame.blocks; ++n) {
            int n2 = 0;
            for (int n3 : rtFrame.block) {
                if (n3 != n) continue;
                ++n2;
            }
            this.point[n] = new int[rtFrame.rows.value * n2 * 2][2];
            this.saturated[n] = new int[n2];
        }
        this.neighbours = new int[rtFrame.rows.value][];
        for (n = 0; n < this.neighbours.length; ++n) {
            this.neighbours[n] = n > 0 && n < this.neighbours.length - 1 ? new int[]{n - 1, n + 1} : (n > 0 ? new int[]{n - 1} : new int[]{n + 1});
        }
        this.resetIndex = new int[rtFrame.blocks];
        this.index = new int[rtFrame.blocks];
    }

    public final void add(int n, int n2, int n3) {
        this.point[n][this.index[n]][ValueCorrectionPixels.W] = n2;
        this.point[n][this.index[n]][ValueCorrectionPixels.P] = n3;
        int n4 = n;
        this.index[n4] = this.index[n4] + 1;
    }

    public int resetIndex(int n) {
        return this.resetIndex[n];
    }

    public int size(int n) {
        return this.index[n];
    }

    public int[] get(int n, int n2) {
        return this.point[n][n2];
    }

    public int[] getNeighbours(int n) {
        return this.neighbours[n];
    }

    public void reset(int n) {
        this.index[n] = this.resetIndex[n];
    }

    public void addFromFrame(RtFrame rtFrame) {
        for (int i = 0; i < rtFrame.blocks; ++i) {
            this.index[i] = 0;
            FloatMatrix floatMatrix = rtFrame.getMatrix(i);
            for (int j = 0; j < floatMatrix.columns; ++j) {
                int n;
                if (this.incIdxArray != null) {
                    for (n = 0; n < this.incIdxArray.length; ++n) {
                        if (!(floatMatrix.get(this.incIdxArray[n], j) > 0.0f)) continue;
                        this.add(i, n, j);
                    }
                    continue;
                }
                for (n = 0; n < floatMatrix.rows; ++n) {
                    if (!(floatMatrix.get(n, j) > 0.0f)) continue;
                    this.add(i, n, j);
                }
            }
            this.resetIndex[i] = this.index[i];
        }
    }
}

