/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.descriptor.discriminatory;

import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Properties;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.evince.datasource.MeasurementDataSource;
import se.prediktera.breeze.evince.datasource.MeasurementImportInfo;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.LoadHelper;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.windows.FloatTextWindow;
import se.prediktera.map.plot.layout.AbstractPlotLayout;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class DiscriminatoryAnalysis {
    private final double modelsamples = 50.0;
    private final int wait = 5;
    private final int max_components = 5;
    private final double cutOffLow = 0.4;
    private final double cutOffHigh = 2.0;
    private final double dcritFactor = 3.0;
    private final double q2y_threshold_low = 2.4;
    private final double q2y_threshold_medium = 2.8;
    private final double q2y_threshold_high = 3.2;
    private BufferedImage resultImage;

    public double perform(BreezeProgressManager breezeProgressManager, List<BasicSample> list, CategoryFactor categoryFactor) {
        Project_GUI project_GUI = Project_GUI.createNewProject((boolean)false);
        MeasurementDataSource measurementDataSource = new MeasurementDataSource(list);
        measurementDataSource.autoIdentifyData(breezeProgressManager, Integer.MAX_VALUE);
        DataSet dataSet = LoadHelper.loadDataSource((Project_GUI)project_GUI, (ProgressManager)breezeProgressManager, (AbstractImportInfo)new MeasurementImportInfo(), (CellIdentifierModel)measurementDataSource, (Properties)new Properties());
        dataSet.createModification((ProgressManager)breezeProgressManager, "var", "snv");
        dataSet.createModification((ProgressManager)breezeProgressManager, "var", "center");
        AbstractModel abstractModel = dataSet.createModel((ProgressManager)breezeProgressManager, "pca", Double.valueOf(3.0));
        dataSet.includeOnly((ProgressManager)breezeProgressManager, "obs", abstractModel, "spacefilling", Double.valueOf(50.0), (Properties)new ScriptHelper.ScriptProperties(new String[]{"randomseed=0"}));
        AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)dataSet.get("xtraining");
        int n = Math.min(abstractDataMatrix.getN() - 2, 5);
        EvinceScriptCommands.apply((ProgressManager)breezeProgressManager, (String)"GAPLSDA", (BasicTreeInterface)dataSet, (Properties)new ScriptHelper.ScriptProperties(new String[]{"maxcomponents=" + n, "wait=5"}));
        dataSet.setTest(Double.valueOf(1.0));
        AbstractModel abstractModel2 = dataSet.createModel((ProgressManager)breezeProgressManager, "PLS-DA", (Properties)new ScriptHelper.ScriptProperties(new String[]{"ycategory=Type", "crossvalidation=true", "maxcomponents=" + n}));
        abstractModel2.setName("DescriptorAnalysis");
        abstractModel2.set("cutOffLow", Double.valueOf(0.4));
        abstractModel2.set("cutOffHigh", Double.valueOf(2.0));
        double d = abstractModel2.getDcritX();
        abstractModel2.setUseDcrit(true);
        abstractModel2.setDcritX(d * 3.0);
        AbstractDataMatrix abstractDataMatrix2 = abstractModel2.getMatrixByName("q2y_cum");
        Double d2 = abstractDataMatrix2.getValue();
        double d3 = Math.max(0.0, (double)((int)(d2 * 100.0) / 10 - 7) * 1.33) + 1.0;
        Type type = this.calculateType(d3);
        DiscriminatoryAnalysis.setTypeCategory(dataSet.getCategory("Type"), type, list, categoryFactor);
        abstractModel2.applyChanges((ProgressManager)breezeProgressManager);
        this.resultImage = DiscriminatoryAnalysis.createResultImage(breezeProgressManager, project_GUI, abstractModel2);
        System.out.println((Object)type);
        dataSet.close();
        return d3;
    }

    private static void setTypeCategory(InnerColumnClass innerColumnClass, Type type, List<BasicSample> list, CategoryFactor categoryFactor) {
        innerColumnClass.setClassSettings(Double.valueOf(1.0), "Unknown", "red");
        switch (type.ordinal()) {
            case 0: {
                innerColumnClass.setClassSettings(Double.valueOf(2.0), "A", "green");
                innerColumnClass.setClassSettings(Double.valueOf(3.0), "A", "green");
                break;
            }
            case 3: {
                innerColumnClass.setClassSettings(Double.valueOf(2.0), "A", "green");
                innerColumnClass.setClassSettings(Double.valueOf(3.0), "B", "yellow");
                break;
            }
            case 1: {
                innerColumnClass.setClassSettings(Double.valueOf(2.0), "A", "yellow");
                innerColumnClass.setClassSettings(Double.valueOf(3.0), "B", "blue");
                break;
            }
            case 2: {
                innerColumnClass.setClassSettings(Double.valueOf(2.0), "A", "green");
                innerColumnClass.setClassSettings(Double.valueOf(3.0), "B", "blue");
            }
        }
        ClassTypes classTypes = innerColumnClass.getObject();
        for (int i = 0; i < list.size(); ++i) {
            String string = classTypes.getTypeDescription((int)innerColumnClass.getValueShort(i));
            int n = categoryFactor.getClassIndex(string);
            list.get(i).getSampleValues().setValue(categoryFactor, n);
        }
    }

    public Type calculateType(double d) {
        if (d <= 2.4) {
            return Type.Connected;
        }
        if (d < 3.2) {
            if (d < 2.8) {
                return Type.ProbablyConnected;
            }
            return Type.ProbablyDisconnected;
        }
        return Type.Disconnected;
    }

    private static BufferedImage createResultImage(BreezeProgressManager breezeProgressManager, Project_GUI project_GUI, AbstractModel abstractModel) {
        AbstractPlotLayout abstractPlotLayout = (AbstractPlotLayout)EvinceScriptCommands.createPlot((Project_GUI)project_GUI, (ProgressManager)breezeProgressManager, (String)"Score2D", (DataTreeInterface)abstractModel, null, (Properties)new Properties());
        AbstractPrediction abstractPrediction = abstractModel.getLocalPredictionNode();
        AbstractDataMatrix abstractDataMatrix = (AbstractDataMatrix)abstractPrediction.get("tpred");
        abstractPlotLayout.set("root", (Object)abstractDataMatrix);
        abstractPlotLayout.setColor(new Object[]{"fixed", "gray"});
        abstractPlotLayout.setSize(new Object[]{"fixed", 3.0});
        AbstractAxisLayer abstractAxisLayer = (AbstractAxisLayer)abstractPlotLayout.addLayer(abstractDataMatrix);
        abstractAxisLayer.setSize(new Object[]{"fixed", 7.0});
        abstractAxisLayer.setColor(new Object[]{"predictioncategory"});
        String string = EvinceScriptCommands.getConstant((String)"date", (String)"HHmmss").toString();
        abstractPlotLayout.setTitle("Discriminatory Analysis Model");
        abstractPlotLayout.set("tag", (Object)string);
        FloatTextWindow floatTextWindow = (FloatTextWindow)abstractPlotLayout.getArea("labelx");
        floatTextWindow.set("text", "Component 1");
        FloatTextWindow floatTextWindow2 = (FloatTextWindow)abstractPlotLayout.getArea("labely");
        floatTextWindow2.set("text", "Component 2");
        abstractPlotLayout.addLegend(new Object[]{"color", new ScriptHelper.ScriptProperties(new ScriptHelper.Property[]{new ScriptHelper.Property("title", "Type")})});
        return abstractPlotLayout.makeBufferedImageScreenShot(800, 800, false);
    }

    public BufferedImage getResultImage() {
        return this.resultImage;
    }

    private void adjustAccordingToType() {
    }

    public static enum Type {
        Connected,
        ProbablyConnected,
        ProbablyDisconnected,
        Disconnected;

    }
}

