/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.function.segmentation.spatial;

import java.util.HashMap;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FileParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowCategoryFactorParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractHolderSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentationInfo;
import se.prediktera.breeze.common.realtime.segmentation.spatial.SpatialObjectFactorList;
import se.prediktera.breeze.common.realtime.segmentation.spatial.SpatialObjectList;
import se.prediktera.breeze.common.util.image.RtSpatialObject;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class PixelClassSegmentation
extends AbstractHolderSegmentation {
    public PixelClassSegmentation(AbstractSegmentationInfo abstractSegmentationInfo) {
        super(abstractSegmentationInfo);
        this.addParameter(new FileParameter(this, "file", "File", "", ""){

            @Override
            public void customizeDialog(jopensaveDialog jopensaveDialog2) {
                jopensaveDialog2.addExtension("raw", "ENVI raw file");
            }
        }, 1);
        this.addParameter(new WorkflowCategoryFactorParameter("factor"), 1);
        this.addOutput("value");
    }

    @Override
    public String getOutputName(int n) {
        return "Segmentation";
    }

    public static class Info
    extends AbstractSegmentationInfo {
        @Override
        public String getImageIcon() {
            return "from_file";
        }

        @Override
        public PixelClassSegmentation createFunction() {
            return new PixelClassSegmentation(this);
        }

        public String toString() {
            return "PixelMaskSegmentation";
        }

        @Override
        public String getName() {
            return "Pixel mask";
        }

        @Override
        public String getDescription() {
            return "Pixel class from external file";
        }

        @Override
        public String getHelp() {
            return "pixel-class-from-external-file";
        }
    }

    public static class SpatialObjectCategoryList
    extends SpatialObjectList
    implements SpatialObjectFactorList {
        private final CategoryFactor factor;
        private final HashMap<RtSpatialObject, Integer> indexHashMap = new HashMap();

        public SpatialObjectCategoryList(CategoryFactor categoryFactor) {
            super(new RtSpatialObject[0]);
            this.factor = categoryFactor;
        }

        public void setIndex(RtSpatialObject rtSpatialObject, int n) {
            this.indexHashMap.put(rtSpatialObject, n);
        }

        public Integer getIndex(RtSpatialObject rtSpatialObject) {
            return this.indexHashMap.get(rtSpatialObject);
        }

        @Override
        public void initObject(BasicSample basicSample, RtSpatialObject rtSpatialObject) {
            basicSample.getSampleValues().setValue(this.factor, this.getIndex(rtSpatialObject).intValue());
        }
    }
}

