/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.holder;

import org.jblas.FloatMatrix;
import org.jblas.exceptions.SizeException;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.backend.realtime.ValueCorrectionPixels;
import se.prediktera.breeze.backend.realtime.module.AbstractRadRefRtModule;
import se.prediktera.breeze.backend.realtime.module.SaturationRtModule;
import se.prediktera.breeze.backend.realtime.module.ValueCorrectionRtModule;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.RtModuleHolder;
import se.prediktera.breeze.common.realtime.frame.FrameReleasePool;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.frame.RtFramePool;
import se.prediktera.breeze.common.realtime.frame.RtFramePoolSingle;
import se.prediktera.breeze.common.realtime.frame.RtFrameStack;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.util.StrayLightManager;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;

public abstract class AbstractRadRefModuleHolder
extends RtModuleHolder {
    private final ValueCorrectionPixels valueCorrectionPixels;
    private final AbstractRadRefRtModule radRefRtModule;
    private final ValueCorrectionRtModule valueCorrectionRtModule;
    private final FrameReleasePool<RtFrame> framePool;
    private int[] optimizedIncIdxArray;
    private final SaturationRtModule saturatedRtModule;

    public AbstractRadRefModuleHolder(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, MaxSignal maxSignal, int n, boolean bl, Workflow workflow, RtFramePredictor.RefSettings refSettings, SaturationRtModule saturationRtModule, String string) {
        super(string);
        this.framePool = bl ? new RtFramePool(bandCount, pixelWidth, bandNames, n) : new RtFramePoolSingle(bandCount, pixelWidth, bandNames, n);
        this.saturatedRtModule = saturationRtModule;
        this.valueCorrectionPixels = new ValueCorrectionPixels(this.framePool.getFrame(), workflow.isValueCorrectionPixels() && bandCount.value > 3 && maxSignal.value > 1000.0f);
        this.radRefRtModule = this.createRtModule(this.valueCorrectionPixels, refSettings);
        if (refSettings.strayLightFile != null && refSettings.strayLightFile.length() > 0) {
            this.radRefRtModule.setStrayLightFrame(new StrayLightManager(refSettings.strayLightFile, pixelWidth, bandCount, refSettings.integrationTime, maxSignal, n));
        }
        this.valueCorrectionRtModule = new ValueCorrectionRtModule(this.valueCorrectionPixels);
        this.realtimeVariables.add(new RtBasicVariable(this, this.getName(), 0.0f, 1.0f));
    }

    protected abstract AbstractRadRefRtModule createRtModule(ValueCorrectionPixels var1, RtFramePredictor.RefSettings var2);

    public void setLatestReferences(SpectralReference.WhiteReference whiteReference, SpectralReference.DarkReference darkReference, int n, boolean bl, Measurement measurement) {
        try {
            this.radRefRtModule.setLatestReferences(whiteReference, darkReference, n, this.optimizedIncIdxArray, measurement);
            if (bl) {
                this.valueCorrectionRtModule.setLatestReferences(whiteReference, darkReference, n);
            }
        }
        catch (SizeException sizeException) {
            throw new RuntimeException("White and dark reference size does not agree", sizeException);
        }
    }

    @Override
    public FloatMatrix apply(RtFrameStack rtFrameStack, RtFrame rtFrame, int n) {
        RtFrame rtFrame2 = rtFrameStack.getReflectanceFrame();
        FloatMatrix floatMatrix = rtFrame2.getMatrix(n);
        floatMatrix.copy(rtFrame.getMatrix(n));
        this.radRefRtModule.apply(floatMatrix, n);
        this.saturatedRtModule.apply(floatMatrix, n);
        this.valueCorrectionRtModule.apply(floatMatrix, n);
        for (RtModuleHolder rtModuleHolder : this.holders) {
            rtModuleHolder.apply(rtFrameStack, rtFrame2, n);
        }
        return null;
    }

    @Override
    public RtFrame getResultFrame(RtFrameStack rtFrameStack) {
        return rtFrameStack.getReflectanceFrame();
    }

    @Override
    public void poolNewFrame(RtFrameStack rtFrameStack, Frame frame, int n) {
        rtFrameStack.setReflectanceFrame(this.framePool.getFrame());
        this.radRefRtModule.setFrameNumber(rtFrameStack.getFrameNumber());
    }

    @Override
    public void optimize(int[] nArray) {
        this.optimizedIncIdxArray = nArray;
        this.framePool.updateBandCount(new BandCount(nArray.length));
        this.valueCorrectionPixels.initiate(this.framePool.getFrame(), nArray);
    }
}

