/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.holder;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.backend.realtime.module.AbsorbanceRtModule;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.RtModuleHolder;
import se.prediktera.breeze.common.realtime.frame.FrameReleasePool;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.frame.RtFramePoolGlobalHandler;
import se.prediktera.breeze.common.realtime.frame.RtFrameStack;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class RtAbsorbanceModuleHolder
extends RtModuleHolder {
    private final AbsorbanceRtModule absorbanceRealtimeModule = new AbsorbanceRtModule();
    private final FrameReleasePool<RtFrame> framePool;

    public RtAbsorbanceModuleHolder(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, int n, boolean bl) {
        super("Absorbance");
        this.framePool = RtFramePoolGlobalHandler.getInstance().createAbsorbancePool(bandCount, pixelWidth, bandNames, n, bl);
        this.realtimeVariables.add(new RtBasicVariable(this, this.getName(), 0.0f, 1.0f));
    }

    @Override
    public FloatMatrix apply(RtFrameStack rtFrameStack, RtFrame rtFrame, int n) {
        RtFrame rtFrame2 = rtFrameStack.getAbsorbanceFrame();
        rtFrame2.getMatrix(n).copy(rtFrame.getMatrix(n));
        this.absorbanceRealtimeModule.apply(rtFrame2.getMatrix(n), n);
        for (RtModuleHolder rtModuleHolder : this.holders) {
            rtModuleHolder.apply(rtFrameStack, rtFrame2, n);
        }
        return null;
    }

    public AbsorbanceRtModule getAbsorbanceRealtimeModule() {
        return this.absorbanceRealtimeModule;
    }

    @Override
    public RtFrame getResultFrame(RtFrameStack rtFrameStack) {
        return rtFrameStack.getAbsorbanceFrame();
    }

    @Override
    public void poolNewFrame(RtFrameStack rtFrameStack, Frame frame, int n) {
        rtFrameStack.setAbsorbanceFrame(this.framePool.getFrame());
    }

    @Override
    public void optimize(int[] nArray) {
        this.framePool.updateBandCount(new BandCount(nArray.length));
    }
}

