/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.holder;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.backend.realtime.module.SaturationRtModule;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.RtModuleHolder;
import se.prediktera.breeze.common.realtime.frame.FrameReleasePool;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.frame.RtFramePoolGlobalHandler;
import se.prediktera.breeze.common.realtime.frame.RtFramePoolSingle;
import se.prediktera.breeze.common.realtime.frame.RtFrameStack;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.util.raw.RawFileFrameWriter;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class RtRawModuleHolder
extends RtModuleHolder {
    private FrameReleasePool<RtFrame> framePool;
    private final BandCount frameRows;
    private final PixelWidth frameColumns;
    private final BandNames bandNames;
    private final int blocks;
    private RawFileFrameWriter.Live liveRawWriter;
    private int[] optimizedIncIdxArray;
    private final SaturationRtModule saturatedRtModule;
    private final boolean useReferences;

    public RtRawModuleHolder(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, MaxSignal maxSignal, int n, boolean bl, SaturationRtModule saturationRtModule, boolean bl2) {
        super("Raw");
        this.frameRows = bandCount;
        this.frameColumns = pixelWidth;
        this.bandNames = bandNames;
        this.blocks = n;
        this.saturatedRtModule = saturationRtModule;
        this.useReferences = bl2;
        this.framePool = RtFramePoolGlobalHandler.getInstance().createRawPool(this.frameRows, this.frameColumns, bandNames, n, bl);
        this.realtimeVariables.add(new RtBasicVariable(this, this.getName(), 0.0f, maxSignal.value));
    }

    public void primeWithRawData(RtFrameStack rtFrameStack, Frame frame, int n, int n2) {
        RtFrame rtFrame = rtFrameStack.rawFrame();
        frame.copyFrameIntoBlock(rtFrame, n, this.optimizedIncIdxArray);
        if (this.liveRawWriter != null) {
            frame.copyFrameBlock(rtFrameStack.getFrame(), rtFrame, n);
        }
    }

    @Override
    public FloatMatrix apply(RtFrameStack rtFrameStack, RtFrame rtFrame, int n) {
        RtFrame rtFrame2 = rtFrameStack.rawFrame();
        FloatMatrix floatMatrix = rtFrame2.getMatrix(n);
        this.saturatedRtModule.checkSaturated(floatMatrix, n);
        if (!this.useReferences) {
            this.saturatedRtModule.apply(floatMatrix, n);
        }
        for (RtModuleHolder rtModuleHolder : this.holders) {
            rtModuleHolder.apply(rtFrameStack, rtFrame2, n);
        }
        return null;
    }

    @Override
    public RtFrame getResultFrame(RtFrameStack rtFrameStack) {
        return rtFrameStack.rawFrame();
    }

    @Override
    public void poolNewFrame(RtFrameStack rtFrameStack, Frame frame, int n) {
        rtFrameStack.setRawFrame(this.framePool.getFrame());
        if (this.liveRawWriter != null) {
            rtFrameStack.setFrame(this.liveRawWriter.getFrameFromPool());
        }
    }

    public void updatePool(RawFileFrameWriter.Live live, boolean bl) {
        this.liveRawWriter = live;
        if (bl && this.framePool instanceof RtFramePoolSingle) {
            this.framePool = RtFramePoolGlobalHandler.getInstance().createRawPool(this.frameRows, this.frameColumns, this.bandNames, this.blocks, true);
        }
    }

    @Override
    public void optimize(int[] nArray) {
        this.optimizedIncIdxArray = nArray;
        this.framePool.updateBandCount(new BandCount(nArray.length));
    }
}

