/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.holder;

import java.util.List;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.realtime.RtModuleHolder;
import se.prediktera.breeze.common.realtime.frame.FrameReleasePool;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.frame.RtFramePool;
import se.prediktera.breeze.common.realtime.frame.RtFrameStack;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class RtTransformationModuleHolder
extends RtModuleHolder {
    private final FrameReleasePool<RtFrame> framePool;
    private final List<RtModule> transformationModules;
    private final String id;

    public RtTransformationModuleHolder(List<RtModule> list, BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, int n, boolean bl) {
        super("Transformation");
        this.transformationModules = list;
        this.id = UniqueUID.getUniqueId();
        this.framePool = bl ? null : new RtFramePool(bandCount, pixelWidth, bandNames, n);
    }

    @Override
    public FloatMatrix apply(RtFrameStack rtFrameStack, RtFrame rtFrame, int n) {
        FloatMatrix floatMatrix;
        if (this.framePool != null) {
            floatMatrix = this.getResultFrame(rtFrameStack).getMatrix(n);
            floatMatrix.copy(rtFrame.getMatrix(n));
        } else {
            floatMatrix = rtFrame.getMatrix(n);
        }
        for (RtModule rtModule : this.transformationModules) {
            rtModule.apply(floatMatrix, n);
        }
        return null;
    }

    @Override
    public RtFrame getResultFrame(RtFrameStack rtFrameStack) {
        return rtFrameStack.getFrame(this.id);
    }

    @Override
    public void poolNewFrame(RtFrameStack rtFrameStack, Frame frame, int n) {
        if (this.framePool != null) {
            rtFrameStack.addFrame(this.id, this.framePool.getFrame());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }
}

