/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.module;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.realtime.RtModule;

public class AbsorbanceRtModule
implements RtModule {
    private static final ReflectanceToAbsorbance refToAbs = new ReflectanceToAbsorbance();

    @Override
    public void apply(FloatMatrix floatMatrix, int n) {
        refToAbs.apply(floatMatrix, n);
    }

    public String toString() {
        return "Absorbance";
    }

    public static class ReflectanceToAbsorbance {
        private final double toLog10 = 1.0 / Math.log(10.0);
        private final int resolution = 1000000;
        private final int tablesize = 10000000;
        private final float[] mlog10table = new float[10000001];

        public ReflectanceToAbsorbance() {
            for (int i = 0; i < this.mlog10table.length; ++i) {
                this.mlog10table[i] = (float)(-Math.log((double)i / 1.0E7 * 10.0) * this.toLog10);
            }
            this.mlog10table[0] = 0.0f;
        }

        public final void apply(FloatMatrix floatMatrix, int n) {
            for (int i = 0; i < floatMatrix.length; ++i) {
                floatMatrix.data[i] = this.mlog10table[(int)(floatMatrix.data[i] * 1000000.0f)];
            }
        }

        public final float mlog10(float f) {
            return this.mlog10table[(int)(f * 1000000.0f)];
        }
    }
}

