/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.module;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.backend.realtime.ValueCorrectionPixels;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.realtime.frame.RefFrame;
import se.prediktera.breeze.common.util.StrayLightManager;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.entry.measurement.Measurement;

public abstract class AbstractRadRefRtModule
implements RtModule {
    public static final int MAXIMUM_REFLECTANCE = 10;
    protected RefFrame refFrame = null;
    protected final ValueCorrectionPixels valueCorrectionPixels;
    protected final RtFramePredictor.RefSettings refSettings;
    private SpectralReference.WhiteReference lastestWhiteReference;
    private SpectralReference.DarkReference latestDarkReference;
    private StrayLightManager strayLightFrame;
    private int frameCount;
    private double percent;
    private double percentAfter;
    private final boolean checkData;

    public AbstractRadRefRtModule(ValueCorrectionPixels valueCorrectionPixels, RtFramePredictor.RefSettings refSettings) {
        this.valueCorrectionPixels = valueCorrectionPixels;
        this.refSettings = refSettings;
        this.checkData = valueCorrectionPixels.applyValueCorrection || refSettings.convertTo.isCalcAbsorbance();
    }

    public void setFrameNumber(long l) {
        if (this.frameCount > 0) {
            this.percent = (double)((long)(this.frameCount - 1) - l) / (double)(this.frameCount - 1);
            this.percentAfter = 1.0 - this.percent;
        }
    }

    @Override
    public void apply(FloatMatrix floatMatrix, int n) {
        this.valueCorrectionPixels.reset(n);
        if (this.strayLightFrame != null) {
            this.strayLightFrame.apply(floatMatrix, n);
        }
        if (this.refFrame.minRefFrame != null) {
            FloatMatrix floatMatrix2 = this.refFrame.minRefFrame.getMatrix(n);
            if (this.refFrame.minAfterRefFrame != null && this.frameCount > 0) {
                float[] fArray = floatMatrix.data;
                float[] fArray2 = floatMatrix2.data;
                float[] fArray3 = this.refFrame.minAfterRefFrame.getMatrix((int)n).data;
                for (int i = 0; i < floatMatrix.length; ++i) {
                    int n2 = i;
                    fArray[n2] = (float)((double)fArray[n2] - ((double)fArray2[i] * this.percent + (double)fArray3[i] * this.percentAfter));
                }
            } else {
                floatMatrix.subi(floatMatrix2);
            }
        }
    }

    protected void checkData(FloatMatrix floatMatrix, int n, boolean bl) {
        if (!this.checkData) {
            return;
        }
        float[] fArray = floatMatrix.data;
        if (bl) {
            for (int i = 0; i < fArray.length; ++i) {
                float f = fArray[i];
                if (!(f > 10.0f) && !(f < 0.0f)) continue;
                fArray[i] = 0.0f;
                this.valueCorrectionPixels.add(n, floatMatrix.indexRows(i), floatMatrix.indexColumns(i));
            }
        } else {
            for (int i = 0; i < fArray.length; ++i) {
                float f = fArray[i];
                if (!(f < 0.0f)) continue;
                fArray[i] = 0.0f;
                this.valueCorrectionPixels.add(n, floatMatrix.indexRows(i), floatMatrix.indexColumns(i));
            }
        }
    }

    public String toString() {
        return "Reflectance";
    }

    public RefFrame setLatestReferences(SpectralReference.WhiteReference whiteReference, SpectralReference.DarkReference darkReference, int n, int[] nArray, Measurement measurement) {
        if (this.lastestWhiteReference != whiteReference || this.latestDarkReference != darkReference) {
            this.refFrame = RefFrame.createRefFrameFromReferences(whiteReference, darkReference, n, nArray, this.refSettings, this.strayLightFrame, true, measurement);
            this.lastestWhiteReference = whiteReference;
            this.latestDarkReference = darkReference;
            this.frameCount = measurement != null ? measurement.rawFile().header().frameCount().value : 0;
        }
        return this.refFrame;
    }

    public void setRefFrame(RefFrame refFrame) {
        this.refFrame = refFrame;
    }

    public void initForTest(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n) {
        this.refFrame = RefFrame.createRefFrame(floatMatrix, null, floatMatrix2, n, 1.0f, null, null, true);
    }

    public void setFrameCount(int n) {
        this.frameCount = n;
    }

    public void setStrayLightFrame(StrayLightManager strayLightManager) {
        this.strayLightFrame = strayLightManager;
    }
}

