/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.module;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.backend.realtime.FloatMatrixOptimizer;
import se.prediktera.breeze.backend.realtime.RtModuleWithReverse;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.RtModule;

public class CenterRtModule
implements RtModule,
RtModuleWithReverse {
    private FloatMatrix columnVector;

    public CenterRtModule() {
    }

    public CenterRtModule(RtModelParameters.RtModuleSetup rtModuleSetup) {
        this(rtModuleSetup.getVector("vector"));
    }

    public CenterRtModule(double[] dArray) {
        this.columnVector = new FloatMatrix(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            this.columnVector.put(i, (float)dArray[i]);
        }
    }

    @Override
    public void apply(FloatMatrix floatMatrix, int n) {
        FloatMatrixOptimizer.subiColumnVector(floatMatrix, this.columnVector);
    }

    @Override
    public void applyReverse(FloatMatrix floatMatrix) {
        FloatMatrixOptimizer.addiColumnVector(floatMatrix, this.columnVector);
    }

    public String toString() {
        return "Center";
    }

    public void init(FloatMatrix floatMatrix) {
        this.columnVector = floatMatrix;
    }
}

