/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.module;

import java.util.ArrayList;
import java.util.List;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.map.datasetcontainer.transform.cr.ConvexHull;

public class ContinuumRemovalRtModule
implements RtModule {
    private final int leftOffset;
    private final int rightOffset;

    public ContinuumRemovalRtModule(int n, int n2) {
        this.leftOffset = n;
        this.rightOffset = n2;
    }

    @Override
    public void apply(FloatMatrix floatMatrix, int n) {
        int n2 = floatMatrix.rows - this.rightOffset;
        for (int i = 0; i < floatMatrix.columns; ++i) {
            ArrayList<ConvexHull.Point> arrayList = new ArrayList<ConvexHull.Point>();
            for (int j = this.leftOffset; j < n2; ++j) {
                arrayList.add(new ConvexHull.Point(j, floatMatrix.get(j, i)));
            }
            List list = ConvexHull.compute(arrayList);
            for (int j = 1; j < list.size(); ++j) {
                ConvexHull.Point point = (ConvexHull.Point)list.get(j - 1);
                ConvexHull.Point point2 = (ConvexHull.Point)list.get(j);
                int n3 = point.X;
                int n4 = point2.X;
                float f = point.Y;
                float f2 = point2.Y;
                float f3 = (f2 - f) / (float)(n4 - n3);
                float f4 = f - f3 * (float)n3;
                for (int k = n3; k < n4; ++k) {
                    float f5 = f3 * (float)k + f4;
                    if (f5 == 0.0f) {
                        floatMatrix.put(k, i, 1.0f);
                        continue;
                    }
                    floatMatrix.put(k, i, floatMatrix.get(k, i) / f5);
                }
            }
            floatMatrix.put(n2 - 1, i, 1.0f);
        }
    }

    public String toString() {
        return "ContinuumRemoval";
    }
}

