/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.module;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.RtModule;

public class DerivateRtModule
implements RtModule {
    final Type type;

    public DerivateRtModule(int n, int n2) {
        this.type = n == 2 ? new Type2(this, n2) : new Type1(this);
    }

    public DerivateRtModule(RtModelParameters.RtModuleSetup rtModuleSetup, int n) {
        this((int)rtModuleSetup.getScalar("type"), n);
    }

    @Override
    public void apply(FloatMatrix floatMatrix, int n) {
        this.type.apply(floatMatrix, n);
    }

    public String toString() {
        return "Derivate";
    }

    private class Type2
    implements Type {
        private FloatMatrix[] cacheVector;

        public Type2(DerivateRtModule derivateRtModule, int n) {
            this.cacheVector = new FloatMatrix[n];
        }

        @Override
        public void apply(FloatMatrix floatMatrix, int n) {
            if (this.cacheVector[n] == null) {
                this.cacheVector[n] = new FloatMatrix(1, floatMatrix.rows);
            }
            int n2 = floatMatrix.getRows();
            for (int i = 0; i < floatMatrix.getColumns(); ++i) {
                int n3;
                for (n3 = 0; n3 < n2; ++n3) {
                    this.cacheVector[n].put(n3, floatMatrix.get(n3, i));
                }
                for (n3 = 1; n3 < n2 - 1; ++n3) {
                    floatMatrix.put(n3, i, (this.cacheVector[n].get(n3 + 1) - this.cacheVector[n].get(n3 - 1)) / 2.0f);
                }
                floatMatrix.put(0, i, floatMatrix.get(1, i));
                floatMatrix.put(n2 - 1, i, floatMatrix.get(n2 - 2, i));
            }
        }
    }

    static interface Type {
        public void apply(FloatMatrix var1, int var2);
    }

    private class Type1
    implements Type {
        private Type1(DerivateRtModule derivateRtModule) {
        }

        @Override
        public void apply(FloatMatrix floatMatrix, int n) {
            int n2 = floatMatrix.getRows();
            for (int i = 0; i < floatMatrix.getColumns(); ++i) {
                for (int j = 0; j < n2 - 1; ++j) {
                    floatMatrix.put(j, i, floatMatrix.get(j + 1, i) - floatMatrix.get(j, i));
                }
                floatMatrix.put(n2 - 1, i, floatMatrix.get(n2 - 2, i));
            }
        }
    }
}

