/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.module;

import java.util.Arrays;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.util.type.MaxSignal;

public class SaturationRtModule
implements RtModule {
    private final int[][] saturated;
    private final int maxSaturated;
    private final float maxSaturatedBandValue;

    public SaturationRtModule(MaxSignal maxSignal, int n, int n2) {
        boolean bl = MaxSignal.isValid(maxSignal);
        this.maxSaturated = bl ? n2 : 0;
        this.saturated = new int[n][];
        this.maxSaturatedBandValue = Math.max(1000.0f, bl ? maxSignal.value * 0.99f : 0.0f);
    }

    public void checkSaturated(FloatMatrix floatMatrix, int n) {
        if (this.maxSaturated <= 0) {
            return;
        }
        float[] fArray = floatMatrix.data;
        if (this.saturated[n] == null) {
            this.saturated[n] = new int[floatMatrix.getColumns()];
        } else {
            Arrays.fill(this.saturated[n], 0);
        }
        int n2 = floatMatrix.getRows();
        int[] nArray = this.saturated[n];
        for (int i = 0; i < floatMatrix.length; ++i) {
            if (!(fArray[i] > this.maxSaturatedBandValue)) continue;
            int n3 = i / n2;
            nArray[n3] = nArray[n3] + 1;
        }
    }

    @Override
    public void apply(FloatMatrix floatMatrix, int n) {
        if (this.maxSaturated > 0) {
            int[] nArray = this.saturated[n];
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] > this.maxSaturated) {
                    for (int j = 0; j < floatMatrix.rows; ++j) {
                        floatMatrix.put(j, i, 0.0f);
                    }
                }
                nArray[i] = 0;
            }
        }
    }

    public String toString() {
        return "Saturation";
    }
}

