/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.module;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.map.datasetcontainer.transform.savitzky.Savitzky;

public class SavitzkyGolayRtModule
implements RtModule {
    private final int left;
    private final int right;
    private final double[] coefficients;
    private final float[][] rowValuesBlock;

    public SavitzkyGolayRtModule(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, Savitzky.createVector((int)n, (int)n2, (int)n3, (int)n4), n5);
    }

    public SavitzkyGolayRtModule(int n, int n2, double[] dArray, int n3) {
        this.left = n;
        this.right = n2;
        this.coefficients = dArray;
        this.rowValuesBlock = new float[n3][];
    }

    public SavitzkyGolayRtModule(RtModelParameters.RtModuleSetup rtModuleSetup, int n) {
        this((int)rtModuleSetup.getScalar("left"), (int)rtModuleSetup.getScalar("right"), rtModuleSetup.getVector("vector"), n);
    }

    @Override
    public void apply(FloatMatrix floatMatrix, int n) {
        int n2 = floatMatrix.getRows();
        int n3 = floatMatrix.getColumns();
        if (this.rowValuesBlock[n] == null) {
            this.rowValuesBlock[n] = new float[n2 + this.left + this.right];
        }
        float[] fArray = this.rowValuesBlock[n];
        int n4 = n2 + this.left;
        for (int i = 0; i < n3; ++i) {
            int n5;
            for (int j = 0; j < n2; ++j) {
                fArray[j + this.left] = floatMatrix.get(j, i);
            }
            float f = floatMatrix.get(0, i);
            for (int j = 0; j < this.left; ++j) {
                fArray[j] = f;
            }
            float f2 = floatMatrix.get(n2 - 1, i);
            for (n5 = 0; n5 < this.right; ++n5) {
                fArray[n4 + n5] = f2;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                float f3 = 0.0f;
                for (int j = 0; j < this.coefficients.length; ++j) {
                    f3 = (float)((double)f3 + this.coefficients[j] * (double)fArray[n5 + j]);
                }
                floatMatrix.put(n5, i, f3);
            }
        }
    }

    public String toString() {
        return "Savitzky-Golay";
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }
}

