/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.module;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.backend.realtime.FloatMatrixOptimizer;
import se.prediktera.breeze.backend.realtime.RtModuleWithReverse;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.RtModule;

public class UVscaleRtModule
implements RtModule,
RtModuleWithReverse {
    private FloatMatrix columnVector;
    private FloatMatrix oneDivColumnVector;

    public UVscaleRtModule() {
    }

    public UVscaleRtModule(RtModelParameters.RtModuleSetup rtModuleSetup) {
        this(rtModuleSetup.getVector("vector"));
    }

    public UVscaleRtModule(double[] dArray) {
        this.columnVector = new FloatMatrix(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            this.columnVector.put(i, (float)dArray[i]);
        }
        this.createReverseColumnVector(this.columnVector);
    }

    @Override
    public void apply(FloatMatrix floatMatrix, int n) {
        FloatMatrixOptimizer.muliColumnVector(floatMatrix, this.columnVector);
    }

    @Override
    public void applyReverse(FloatMatrix floatMatrix) {
        FloatMatrixOptimizer.muliColumnVector(floatMatrix, this.oneDivColumnVector);
    }

    public String toString() {
        return "UVscale";
    }

    public void init(FloatMatrix floatMatrix) {
        this.columnVector = floatMatrix;
        this.createReverseColumnVector(floatMatrix);
    }

    private void createReverseColumnVector(FloatMatrix floatMatrix) {
        this.oneDivColumnVector = new FloatMatrix(floatMatrix.rows, floatMatrix.columns);
        this.oneDivColumnVector.fill(1.0f);
        this.oneDivColumnVector.divi(floatMatrix);
    }
}

