/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime.module;

import org.jblas.FloatMatrix;
import org.jblas.MatrixFunctions;
import se.prediktera.breeze.backend.realtime.ValueCorrectionPixels;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.AverageFloatMatrix;

public class ValueCorrectionRtModule
implements RtModule {
    public static int W = 0;
    public static int P = 1;
    public static final boolean IS_SPIKE_REMOVAL = false;
    public static final double SPIKE_STDEV_PVALUE = 1.0E-6;
    public static final double SPIKE_STDEV_TVALUE = 4.891638482613603;
    public static final double STDEV_PVALUE = 0.01;
    public static final double STDEV_TVALUE = 2.5758291030596365;
    public static final double W1_PVALUE = 1.0E-4;
    private final ValueCorrectionPixels valueCorrectionPixels;
    private SpectralReference.WhiteReference lastestWhiteReference;
    private SpectralReference.DarkReference latestDarkReference;

    public ValueCorrectionRtModule(ValueCorrectionPixels valueCorrectionPixels) {
        this.valueCorrectionPixels = valueCorrectionPixels;
    }

    public void setLatestReferences(SpectralReference.WhiteReference whiteReference, SpectralReference.DarkReference darkReference, int n) {
        if (this.lastestWhiteReference != whiteReference || this.latestDarkReference != darkReference) {
            if (!darkReference.isEmpty()) {
                FloatMatrix[] floatMatrixArray = darkReference.getMatrix();
                FloatMatrix[] floatMatrixArray2 = whiteReference.getMatrix();
                FloatMatrix floatMatrix = PixelMaskCalculator.calculatePixelMaskMatrix(floatMatrixArray2, floatMatrixArray);
                this.valueCorrectionPixels.addFromFrame(new RtFrame(floatMatrix, n));
            }
            this.lastestWhiteReference = whiteReference;
            this.latestDarkReference = darkReference;
        }
    }

    @Override
    public void apply(FloatMatrix floatMatrix, int n) {
        if (this.valueCorrectionPixels.applyValueCorrection) {
            int[] nArray;
            int n2;
            for (n2 = 0; n2 < this.valueCorrectionPixels.resetIndex(n); ++n2) {
                nArray = this.valueCorrectionPixels.get(n, n2);
                floatMatrix.put(nArray[W], nArray[P], 0.0f);
            }
            for (n2 = 0; n2 < this.valueCorrectionPixels.size(n); ++n2) {
                nArray = this.valueCorrectionPixels.get(n, n2);
                int n3 = 0;
                float f = 0.0f;
                for (int n4 : this.valueCorrectionPixels.getNeighbours(nArray[W])) {
                    float f2 = floatMatrix.get(n4, nArray[P]);
                    if (!(f2 > 0.0f)) continue;
                    f += f2;
                    ++n3;
                }
                floatMatrix.put(nArray[W], nArray[P], n3 > 0 ? f / (float)n3 : 0.0f);
            }
        }
    }

    public String toString() {
        return "ValueCorrection";
    }

    public static class PixelMaskCalculator {
        public static FloatMatrix calculatePixelMaskMatrix(FloatMatrix[] floatMatrixArray, FloatMatrix[] floatMatrixArray2) {
            return PixelMaskCalculator.calculatePixelMatrix(floatMatrixArray2, 2.5758291030596365, 9.783276965227206);
        }

        private static FloatMatrix calculatePixelMatrix(FloatMatrix[] floatMatrix, double d, double d2) {
            FloatMatrix floatMatrix22;
            AverageFloatMatrix averageFloatMatrix = new AverageFloatMatrix((FloatMatrix[])floatMatrix);
            FloatMatrix floatMatrix3 = new FloatMatrix(averageFloatMatrix.rows, averageFloatMatrix.columns);
            for (FloatMatrix floatMatrix22 : floatMatrix) {
                floatMatrix3.addi(MatrixFunctions.powi((FloatMatrix)floatMatrix22.sub((FloatMatrix)averageFloatMatrix), (float)2.0f));
            }
            floatMatrix3.divi((float)(((FloatMatrix[])floatMatrix).length - 1));
            MatrixFunctions.sqrti((FloatMatrix)floatMatrix3);
            FloatMatrix floatMatrix4 = averageFloatMatrix.rowMeans();
            FloatMatrix floatMatrix5 = floatMatrix3.divColumnVector(floatMatrix4);
            boolean[] blArray = PixelMaskCalculator.calculateStderrVariance(floatMatrix5);
            floatMatrix22 = new FloatMatrix(averageFloatMatrix.rows, averageFloatMatrix.columns);
            for (int i = 0; i < averageFloatMatrix.rows; ++i) {
                double d3 = 0.0;
                for (int j = 0; j < averageFloatMatrix.columns; ++j) {
                    d3 += Math.pow(averageFloatMatrix.get(i, j) - floatMatrix4.get(i), 2.0);
                }
                double d4 = Math.sqrt(d3 /= (double)(averageFloatMatrix.columns - 1));
                for (int j = 0; j < averageFloatMatrix.columns; ++j) {
                    if (Double.isNaN(floatMatrix5.get(i, j)) || !blArray[j]) continue;
                    double d5 = Math.abs(averageFloatMatrix.get(i, j) - floatMatrix4.get(i));
                    if (d5 > d2 * d4) {
                        floatMatrix22.put(i, j, 1.0f);
                    }
                    if (!(d5 > d) || floatMatrix3.get(i, j) != 0.0f && !((double)floatMatrix5.get(i, j) > d)) continue;
                    floatMatrix22.put(i, j, 1.0f);
                }
            }
            return floatMatrix22;
        }

        private static boolean[] calculateStderrVariance(FloatMatrix floatMatrix) {
            boolean[] blArray = new boolean[floatMatrix.columns];
            block0: for (int i = 0; i < floatMatrix.columns; ++i) {
                for (int j = 1; j < floatMatrix.rows; ++j) {
                    if (floatMatrix.get(j - 1, i) == floatMatrix.get(j, i)) continue;
                    blArray[i] = true;
                    continue block0;
                }
            }
            return blArray;
        }
    }
}

