/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry;

import java.util.ArrayList;
import se.prediktera.breeze.common.entry.BasicEntry;

public class BasicEntryList<T extends BasicEntry>
extends ArrayList<T> {
    public T byId(String string) {
        if (string != null) {
            for (BasicEntry basicEntry : this.safeSnapshot()) {
                if (basicEntry == null || !string.equals(basicEntry.getUid())) continue;
                return (T)basicEntry;
            }
        }
        return null;
    }

    public T byName(String string) {
        if (string != null) {
            for (BasicEntry basicEntry : this.safeSnapshot()) {
                if (basicEntry == null || !string.equals(basicEntry.getName())) continue;
                return (T)basicEntry;
            }
        }
        return null;
    }

    public T byIdOrName(String string) {
        T t = this.byId(string);
        if (t == null) {
            t = this.byName(string);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUniqueId(T t) {
        if (t != null) {
            BasicEntryList basicEntryList = this;
            synchronized (basicEntryList) {
                if (this.byId(t.getUid()) == null) {
                    this.add(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<T> safeSnapshot() {
        BasicEntryList basicEntryList = this;
        synchronized (basicEntryList) {
            return new ArrayList(this);
        }
    }
}

