/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyseList;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflowList;

public class BasicMasterCache {
    private static BasicMasterCache instance;
    private MasterCacheInterface masterCacheInterface;

    public static BasicMasterCache getInstance() {
        if (instance == null) {
            instance = new BasicMasterCache();
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public void setMasterCacheInterface(MasterCacheInterface masterCacheInterface) {
        this.masterCacheInterface = masterCacheInterface;
    }

    public MasterCacheInterface getMasterCacheInterface() {
        return this.masterCacheInterface;
    }

    public BasicWorkflowList getStudyList() {
        if (this.masterCacheInterface == null) {
            return new BasicWorkflowList();
        }
        return this.masterCacheInterface.getStudyList();
    }

    public BasicAnalyseList<BasicAnalyse> getAnalyseList() {
        if (this.masterCacheInterface == null) {
            return new BasicAnalyseList<BasicAnalyse>();
        }
        return this.masterCacheInterface.getAnalyseList();
    }

    public BasicAnalyseList<BasicAnalyse> getRtAnalyseList() {
        if (this.masterCacheInterface == null) {
            return new BasicAnalyseList<BasicAnalyse>();
        }
        return this.masterCacheInterface.getRtAnalyseList();
    }

    public BasicWorkflowList getWorkflowList() {
        if (this.masterCacheInterface == null) {
            return new BasicWorkflowList();
        }
        return this.masterCacheInterface.getWorkflowList();
    }

    public List<BasicAnalyse> getAnalyseLists() {
        ArrayList<BasicAnalyse> arrayList = new ArrayList<BasicAnalyse>(this.getAnalyseList());
        arrayList.addAll(this.getRtAnalyseList());
        return arrayList;
    }

    public BasicAnalyse getAnalyseById(String string) {
        BasicAnalyse basicAnalyse = (BasicAnalyse)this.getAnalyseList().byId(string);
        if (basicAnalyse != null) {
            return basicAnalyse;
        }
        return (BasicAnalyse)this.getRtAnalyseList().byId(string);
    }

    public static interface MasterCacheInterface {
        public BasicWorkflowList getStudyList();

        public BasicAnalyseList getAnalyseList();

        public BasicAnalyseList getRtAnalyseList();

        public BasicWorkflowList getWorkflowList();
    }
}

