/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry;

import java.awt.Color;
import lombok.Generated;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public enum BreezeType {
    Project("Project", BreezeTheme.PROJECT_COLOR),
    Analyse("Model", BreezeTheme.MODEL_COLOR),
    Workflow("Workflow", BreezeTheme.PLAY_COLOR),
    Settings("Settings", BreezeTheme.SETTINGS_COLOR),
    Connect("Connect", BreezeTheme.CONNECT_COLOR),
    Recordings("Recordings", BreezeTheme.RECORDINGS_COLOR),
    Recorder("Recorder", BreezeTheme.RECORDER_COLOR);

    private final String desc;
    private final Color color;

    private BreezeType(String string2, Color color) {
        this.desc = string2;
        this.color = color;
    }

    public Color getFromColor() {
        return this.color.brighter();
    }

    public String toString() {
        return this.desc;
    }

    public String getDescs() {
        if (this.desc.endsWith("s")) {
            return this.desc;
        }
        return this.desc + "s";
    }

    public boolean isWorkflow() {
        return this.equals((Object)Project) || this.equals((Object)Workflow);
    }

    public BreezeType getNext() {
        int n = this.ordinal();
        if (n < Workflow.ordinal()) {
            return BreezeType.values()[n + 1];
        }
        return null;
    }

    public BreezeType getPrev() {
        int n = this.ordinal();
        if (n > Project.ordinal() && n < Settings.ordinal()) {
            return BreezeType.values()[n - 1];
        }
        return null;
    }

    public String getIcon() {
        return switch (this.ordinal()) {
            case 1 -> "material/analytics";
            case 2 -> "Workflow_small";
            case 0 -> "material/folder_open";
            case 6 -> "material/videocam";
            default -> null;
        };
    }

    public String getTitle() {
        return switch (this.ordinal()) {
            case 1 -> "Model";
            case 2 -> "Workflow";
            case 0 -> "Analyzer";
            case 6 -> "Recorder";
            default -> null;
        };
    }

    public String getFolderName() {
        return switch (this.ordinal()) {
            case 0 -> "Record";
            case 1 -> "Model";
            case 2 -> "Play";
            default -> null;
        };
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    public Color getColor() {
        return this.color;
    }
}

