/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.analyse;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.common.entry.factor.FactorList;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.category.CategoryList;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.AnalyseSample;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.workflow.Workflow;

public abstract class BasicAnalyse
implements BasicEntry {
    protected final FactorHolder factorHolder = new FactorHolder();
    private Object objectMethod;

    public void checkFullyParsed() {
    }

    @Override
    public abstract String getUid();

    public abstract String getVersion();

    public abstract RtModelParameters getModelParameters(BreezeProgress var1, Workflow var2);

    @Override
    public abstract String getName();

    public abstract ModelMethod getModelMethod();

    public PropertyList getPropertyFactors() {
        return this.factorHolder.getPropertyFactors();
    }

    public CategoryFactor getCategoryFactor() {
        CategoryList categoryList = this.factorHolder.getCategoryFactors();
        if (categoryList.isEmpty()) {
            return null;
        }
        return categoryList.get(0);
    }

    public CategoryList getCategoryFactors() {
        return this.factorHolder.getCategoryFactors();
    }

    public FactorList getFactorList() {
        ModelMethod modelMethod = this.getModelMethod();
        if (modelMethod.isClassification()) {
            return this.getCategoryFactors();
        }
        if (modelMethod.isQuantification()) {
            return this.getPropertyFactors();
        }
        return null;
    }

    public Factor getFactor() {
        FactorList factorList = this.getFactorList();
        if (factorList.size() > 0) {
            return factorList.get(0);
        }
        return null;
    }

    public Factor getFactor(String string) {
        CategoryFactor categoryFactor = this.getCategoryFactors().getByUid(string);
        if (categoryFactor != null) {
            return categoryFactor;
        }
        return this.getPropertyFactors().getByUid(string);
    }

    public String getStudyId() {
        return null;
    }

    public boolean partOfStudy(String string) {
        return string.equals(this.getStudyId());
    }

    public boolean equals(Object object) {
        if (object instanceof BasicAnalyse) {
            BasicAnalyse basicAnalyse = (BasicAnalyse)object;
            String string = this.getUid();
            if (string != null) {
                return string.equals(basicAnalyse.getUid());
            }
        }
        return super.equals(object);
    }

    public AnalyseSample.SampleIncluded sampleIncluded(BasicSample basicSample) {
        return AnalyseSample.SampleIncluded.None;
    }

    public void sampleIncluded(BasicSample basicSample, boolean bl, boolean bl2) {
    }

    public String getFormatedRating() {
        return null;
    }

    public RtFramePredictor.ReferenceConvertTo getConvertTo() {
        return null;
    }

    @Generated
    public FactorHolder getFactorHolder() {
        return this.factorHolder;
    }

    @Generated
    public Object getObjectMethod() {
        return this.objectMethod;
    }

    @Generated
    public void setObjectMethod(Object object) {
        this.objectMethod = object;
    }

    public static enum ModelMethod {
        SamplePca(ModelType.Sample, "PCA"),
        SampleRuntime(ModelType.Sample, "Machine Learning"),
        QuantificationPls(ModelType.Quantification, "PLS"),
        QuantificationRuntime(ModelType.Quantification, "Machine Learning"),
        QuantificationSam(ModelType.Quantification, "SAM"),
        QuantificationUnmixing(ModelType.Quantification, "Unmixing"),
        ClassificationPlsDa(ModelType.Classification, "PLS-DA"),
        SimcaClassification(ModelType.Classification, "SIMCA"),
        ClassificationTensorflow(ModelType.Classification, "Tensorflow"),
        ClassificationCurveSeparation(ModelType.Classification, "CurveSeparation"),
        ClassificationUsgs(ModelType.Classification, "Usgs"),
        ClassificationRuntime(ModelType.Classification, "Machine Learning"),
        ClassificationANN(ModelType.Classification, "ANN"),
        QuantificationExpression(ModelType.Quantification, "Expression"),
        ClassificationLabel(ModelType.Classification, "Label"),
        ClassificationExpression(ModelType.Classification, "Expression Classification"),
        ClassificationSam(ModelType.Classification, "Sam"),
        QuantificationSaturation(ModelType.Quantification, "Saturation"),
        QuantificationMwl(ModelType.Quantification, "Mwl"),
        ClassificationObject(ModelType.Classification, "Object"),
        QuantificationPca(ModelType.Quantification, "QuantificationPca"),
        QuantificationPcaStream(ModelType.Quantification, "QuantificationPcaStream"),
        ClassificationCluster(ModelType.Classification, "ClassificationCluster"),
        ClassificationDataSlicing(ModelType.Classification, "DataSlicing"),
        ClassificationRgb(ModelType.Classification, "RGB"),
        QuantificationRgb(ModelType.Quantification, "PseudoRGB");

        private final ModelType type;
        private final String method;

        private ModelMethod(ModelType modelType, String string2) {
            this.type = modelType;
            this.method = string2;
        }

        public boolean isSample() {
            return this.type.equals((Object)ModelType.Sample);
        }

        public boolean isClassification() {
            return this.type.equals((Object)ModelType.Classification);
        }

        public boolean isQuantification() {
            return this.type.equals((Object)ModelType.Quantification);
        }

        public boolean hasCrossvalidation() {
            return !this.isRuntime() && !this.isSample();
        }

        public String getTypeName() {
            return this.type.toString();
        }

        public boolean supportImportance() {
            return switch (this.ordinal()) {
                case 2, 6 -> true;
                default -> false;
            };
        }

        public boolean supportCutOff() {
            return switch (this.ordinal()) {
                case 6, 11 -> true;
                default -> false;
            };
        }

        public boolean isDefault(Model.Transformation transformation) {
            if (this.equals((Object)ClassificationCurveSeparation)) {
                return transformation.equals((Object)Model.Transformation.Logarithm);
            }
            if (this.isRuntime()) {
                return false;
            }
            return transformation.isDefault();
        }

        public static ModelMethod fromMethod(String string) {
            for (ModelMethod modelMethod : ModelMethod.values()) {
                if (!modelMethod.getMethod().equals(string)) continue;
                return modelMethod;
            }
            throw new RuntimeException("No such model method: " + string);
        }

        public List<ModelMethod> getSimilarWizardMethods() {
            ArrayList<ModelMethod> arrayList = new ArrayList<ModelMethod>();
            switch (this.getType().ordinal()) {
                case 1: {
                    arrayList.add(ClassificationPlsDa);
                    arrayList.add(SimcaClassification);
                    arrayList.add(ClassificationRuntime);
                    arrayList.add(ClassificationCurveSeparation);
                    arrayList.add(ClassificationANN);
                    break;
                }
                case 2: {
                    arrayList.add(QuantificationPls);
                    arrayList.add(QuantificationRuntime);
                    break;
                }
                case 0: {
                    arrayList.add(SamplePca);
                    arrayList.add(SampleRuntime);
                }
            }
            return arrayList;
        }

        public boolean isRuntime() {
            return switch (this.ordinal()) {
                case 1, 3, 11, 12 -> true;
                default -> false;
            };
        }

        public boolean supportMultipleVariables() {
            return this == QuantificationPls;
        }

        @Generated
        public ModelType getType() {
            return this.type;
        }

        @Generated
        public String getMethod() {
            return this.method;
        }
    }

    public static enum ModelType {
        Sample("Sample"),
        Classification("Category"),
        Quantification("Property");

        private final String name;

        private ModelType(String string2) {
            this.name = string2;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

