/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.analyse;

import java.io.File;
import org.w3c.dom.Node;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.entry.workflow.Workflow;

public class RtAnalyse
extends BasicAnalyse {
    private RtModelParameters modelParameters;
    private final String uid;
    private String name;
    private BasicAnalyse.ModelMethod method;
    private String alias;
    private String studyId;
    private RtFramePredictor.ReferenceConvertTo convertTo;
    private String version;

    public RtAnalyse() {
        this.uid = UniqueUID.getUniqueId();
    }

    public RtAnalyse(String string, String string2, BasicAnalyse.ModelMethod modelMethod, String string3) {
        this(string, string2, modelMethod, string3, "1");
    }

    public RtAnalyse(String string, String string2, BasicAnalyse.ModelMethod modelMethod, String string3, String string4) {
        this.uid = string;
        this.name = string2;
        this.method = modelMethod;
        this.studyId = string3;
        this.version = string4;
    }

    public RtAnalyse(Node node) {
        this.uid = XmlParserHelper.getAttribute(node, "id");
        this.name = XmlParserHelper.getAttribute(node, "name");
        this.method = BasicAnalyse.ModelMethod.valueOf(XmlParserHelper.getAttribute(node, "method"));
        for (Node node2 : XmlParserHelper.getNodeList(node)) {
            if (node2.getNodeName().equalsIgnoreCase("variables")) {
                this.factorHolder.parseVariables(node2);
                continue;
            }
            if (!node2.getNodeName().equalsIgnoreCase("models")) continue;
            this.modelParameters = new RtModelParameters(node2);
        }
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public File getXml() {
        return null;
    }

    public void setModelParameters(RtModelParameters rtModelParameters) {
        this.modelParameters = rtModelParameters;
    }

    @Override
    public BasicAnalyse.ModelMethod getModelMethod() {
        return this.method;
    }

    @Override
    public RtModelParameters getModelParameters(BreezeProgress breezeProgress, Workflow workflow) {
        return this.modelParameters;
    }

    public RtModelParameters.RtModel getRtModel() {
        return this.modelParameters.getModel();
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setStudyId(String string) {
        this.studyId = string;
    }

    @Override
    public String getStudyId() {
        return this.studyId;
    }

    @Override
    public boolean isGrayed() {
        return false;
    }

    public String toString() {
        if (this.alias != null) {
            return this.name + " - " + this.alias;
        }
        return this.name;
    }

    public void setConvertTo(RtFramePredictor.ReferenceConvertTo referenceConvertTo) {
        this.convertTo = referenceConvertTo;
    }

    @Override
    public RtFramePredictor.ReferenceConvertTo getConvertTo() {
        return this.convertTo;
    }

    @Override
    public boolean delete(boolean bl) {
        return false;
    }

    @Override
    public EntryData getEntryData() {
        return null;
    }
}

