/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.factor;

import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.SampleVariableOrIdentifier;
import se.prediktera.breeze.common.entry.ThingWithName;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;

public abstract class Factor<F extends Factor<F>>
implements ThingWithName,
SampleVariableOrIdentifier,
FactorOrDescriptor {
    private String name;
    protected String uid;
    protected String origUid;
    protected MinMax minMax = new MinMax(0.0f, 100.0f);
    private boolean dynamicMinMax;

    public Factor(NamedNodeMap namedNodeMap) {
        this.name = namedNodeMap.getNamedItem("name").getNodeValue();
        Node node = namedNodeMap.getNamedItem("id");
        this.uid = node != null ? node.getNodeValue() : UniqueUID.getUniqueId();
        Node node2 = namedNodeMap.getNamedItem("origId");
        this.origUid = node2 != null ? node2.getNodeValue() : null;
    }

    public Factor(String string, String string2) {
        this.name = string;
        this.uid = string2;
    }

    public abstract void appendXMLSettings(Element var1);

    public abstract F clone();

    public abstract String getEntryString(BasicSample var1);

    public abstract float getFloatValue(String var1);

    public float getMax() {
        return this.minMax.max().floatValue();
    }

    public void setMax(float f) {
        this.minMax = new MinMax(this.minMax.min().floatValue(), f);
    }

    public float getMin() {
        return this.minMax.min().floatValue();
    }

    public void setMin(float f) {
        this.minMax = new MinMax(f, this.minMax.max().floatValue());
    }

    public final MinMax getMinMax() {
        return this.minMax;
    }

    public void setMinMax(MinMax minMax) {
        if (minMax != null) {
            this.minMax = minMax;
        }
    }

    public void setDynamicMinMax(boolean bl) {
        this.dynamicMinMax = bl;
    }

    public boolean isDynamicMinMax() {
        return this.dynamicMinMax;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final String getStringValue(BasicSample basicSample) {
        if (basicSample != null) {
            return this.getStringValue(basicSample, 8);
        }
        return "";
    }

    public abstract String getStringValue(BasicSample var1, int var2);

    public abstract String getType();

    @Override
    public Float getValue(BasicSample basicSample) {
        return basicSample.getSampleValues().getValue(this);
    }

    public F cloneKeepId() {
        Object object = this.clone();
        ((Factor)object).uid = this.uid;
        ((Factor)object).origUid = this.origUid;
        return (F)object;
    }

    public F cloneStoreId() {
        Object object = this.clone();
        ((Factor)object).origUid = this.uid;
        return (F)object;
    }

    public void setUid(String string) {
        this.uid = string;
    }

    @Override
    public final String getUid() {
        return this.uid;
    }

    @Override
    public final String getOrigUid() {
        if (this.origUid != null) {
            return this.origUid;
        }
        return this.uid;
    }

    public Element save(Element element) {
        Element element2 = this instanceof CategoryFactor ? XmlParserHelper.addElement(element, "qualitative") : XmlParserHelper.addElement(element, "quantitative");
        element2.setAttribute("id", this.getUid());
        element2.setAttribute("name", this.getName());
        if (this.origUid != null) {
            element2.setAttribute("origId", this.origUid);
        }
        this.appendXMLSettings(element2);
        return element2;
    }

    @Override
    public abstract void setValue(String var1, BasicSample var2);

    public abstract boolean isMissing(BasicSample var1);

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof Factor) {
            return this.hashCode() == object.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.getOrigUid().hashCode();
    }

    public int compare(BasicSample basicSample, BasicSample basicSample2) {
        boolean bl = this.isMissing(basicSample);
        boolean bl2 = this.isMissing(basicSample2);
        if (!bl && !bl2) {
            return Float.compare(basicSample.getVariableValue(this).floatValue(), basicSample2.getVariableValue(this).floatValue());
        }
        if (!bl) {
            return 1;
        }
        if (!bl2) {
            return -1;
        }
        return 0;
    }

    public abstract Thumbnail createThumbnail(Measurement var1, Sample var2, AbstractBreezeFunction var3, BasicAnalyse var4, boolean var5, boolean var6);

    public static enum Type {
        Property,
        Category;

    }
}

