/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.factor;

import java.util.ArrayList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.factor.BasicFactorWrapper;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;

public class FactorCache
extends ArrayList<BasicFactorWrapper> {
    private static FactorCache cache = null;

    public static FactorCache getInstance() {
        if (cache == null) {
            cache = new FactorCache();
        }
        return cache;
    }

    public static void clearInstance() {
        cache = null;
    }

    public Factor getFactor(String string) {
        for (BasicFactorWrapper basicFactorWrapper : this) {
            Factor factor = basicFactorWrapper.getFactor(string);
            if (factor == null) continue;
            return factor;
        }
        return null;
    }

    public boolean hasFactor(String string) {
        return this.getFactor(string) != null;
    }

    private BasicFactorWrapper getFirstWrapper() {
        if (this.size() == 0) {
            this.add(new BasicFactorWrapper());
        }
        return (BasicFactorWrapper)this.get(0);
    }

    public boolean hasFactor(NamedNodeMap namedNodeMap) {
        Node node = namedNodeMap.getNamedItem("id");
        String string = null;
        if (node != null) {
            string = node.getNodeValue();
            return this.hasFactor(string);
        }
        return false;
    }

    public Factor getGlobalFactor(NamedNodeMap namedNodeMap) {
        Node node = namedNodeMap.getNamedItem("id");
        String string = null;
        if (node != null) {
            string = node.getNodeValue();
            return this.getFactor(string);
        }
        return null;
    }

    public Factor getFactor(Factor.Type type, NamedNodeMap namedNodeMap, boolean bl) {
        if (bl && this.hasFactor(namedNodeMap)) {
            return this.getGlobalFactor(namedNodeMap);
        }
        Factor factor = null;
        if (type.equals((Object)Factor.Type.Category)) {
            factor = new CategoryFactor(namedNodeMap);
            this.getFirstWrapper().getFactorHolder().getCategoryFactors().add((CategoryFactor)factor);
        } else if (type.equals((Object)Factor.Type.Property)) {
            factor = new PropertyFactor(namedNodeMap);
            this.getFirstWrapper().getFactorHolder().getPropertyFactors().add((PropertyFactor)factor);
        }
        return factor;
    }
}

