/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.factor;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorCache;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.category.CategoryList;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;

public class FactorHolder {
    private final PropertyList propertyFactors = new PropertyList(this);
    private final CategoryList categoryFactors = new CategoryList(this);

    public PropertyList getPropertyFactors() {
        return this.propertyFactors;
    }

    public CategoryList getCategoryFactors() {
        return this.categoryFactors;
    }

    public boolean factorExists(String string) {
        return FactorHolder.factorExists(string, this.categoryFactors) || FactorHolder.factorExists(string, this.propertyFactors);
    }

    public boolean factorExistsByUID(String string) {
        return FactorHolder.factorExistsByUID(string, this.categoryFactors) || FactorHolder.factorExistsByUID(string, this.propertyFactors);
    }

    public Factor getFactorByName(String string) {
        Factor factor = FactorHolder.getFactorByName(string, this.categoryFactors);
        if (factor == null) {
            factor = FactorHolder.getFactorByName(string, this.propertyFactors);
        }
        return factor;
    }

    public Factor getFactorByUid(String string) {
        Factor factor = FactorHolder.getFactorByUid(string, this.categoryFactors);
        if (factor == null) {
            factor = FactorHolder.getFactorByUid(string, this.propertyFactors);
        }
        return factor;
    }

    public int getFactorIndex(Factor factor) {
        int n = -1;
        n = factor instanceof PropertyFactor ? this.propertyFactors.indexOf(factor) : this.categoryFactors.indexOf(factor);
        if (n == -1) {
            throw new RuntimeException("Factor " + String.valueOf(factor) + " not found");
        }
        return n;
    }

    public List<Factor> getFactors() {
        ArrayList<Factor> arrayList = new ArrayList<Factor>();
        arrayList.addAll(this.getCategoryFactors().getList());
        arrayList.addAll(this.getPropertyFactors().getList());
        return arrayList;
    }

    public void addFactors(FactorHolder factorHolder) {
        for (Factor factor : factorHolder.getCategoryFactors()) {
            this.getCategoryFactors().add((CategoryFactor)factor);
        }
        for (Factor factor : factorHolder.getPropertyFactors()) {
            this.getPropertyFactors().add((PropertyFactor)factor);
        }
    }

    public void addVariableDef(Element element) {
        Element element2 = XmlParserHelper.addElement(element, "variables");
        for (Factor factor : this.getCategoryFactors()) {
            ((CategoryFactor)factor).save(element2);
        }
        for (Factor factor : this.getPropertyFactors()) {
            factor.save(element2);
        }
    }

    public void parseVariables(Node node) {
        FactorCache.getInstance();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            if (string.equals("qualitative")) {
                this.categoryFactors.add(CategoryFactor.parseCategoryFactor(nodeList.item(i)));
            }
            if (!string.equals("quantitative")) continue;
            this.propertyFactors.add(PropertyList.parsePropertyFactor(nodeList.item(i)));
        }
    }

    public void replace(Factor factor, Factor factor2) {
        if (factor instanceof CategoryFactor) {
            List<CategoryFactor> list = this.categoryFactors.getList();
            int n = list.indexOf(factor);
            list.set(n, (CategoryFactor)factor2);
        } else {
            List list = this.propertyFactors.getList();
            int n = list.indexOf(factor);
            list.set(n, factor2);
        }
    }

    public void clear() {
        this.categoryFactors.clear();
        this.propertyFactors.clear();
    }

    public static boolean factorExists(String string, Iterable<? extends Factor> iterable) {
        return FactorHolder.getFactorByName(string, iterable) != null;
    }

    public static boolean factorExistsByUID(String string, Iterable<? extends Factor> iterable) {
        return FactorHolder.getFactorByUid(string, iterable) != null;
    }

    public static Factor getFactorByName(String string, Iterable<? extends Factor> iterable) {
        for (Factor factor : iterable) {
            if (!factor.getName().equalsIgnoreCase(string)) continue;
            return factor;
        }
        return null;
    }

    public static Factor getFactorByNameRemoveSpace(String string, Iterable<? extends Factor> iterable) {
        String string2 = StringHelper.removeSpace(string);
        for (Factor factor : iterable) {
            String string3 = StringHelper.removeSpace(factor.getName());
            if (!string3.equalsIgnoreCase(string2)) continue;
            return factor;
        }
        return null;
    }

    public static Factor getFactorByUid(String string, Iterable<? extends Factor> iterable) {
        for (Factor factor : iterable) {
            if (!factor.getUid().equalsIgnoreCase(string)) continue;
            return factor;
        }
        return null;
    }

    public static Factor getFactorByOrigUid(String string, Iterable<? extends Factor> iterable) {
        for (Factor factor : iterable) {
            if (!factor.getOrigUid().equalsIgnoreCase(string)) continue;
            return factor;
        }
        return null;
    }
}

