/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.factor.category;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;

public class CatClass {
    private final CategoryFactor factor;
    private String color = "NA";
    private String name;
    private String uid;
    private Integer index;
    private Boolean included;
    private final List<CatClass> subClasses = new ArrayList<CatClass>();
    private CatClass parent;
    private String extraInfo;
    private String groupName;
    private String groupColor;
    private boolean noClass;

    public CatClass(String string, CategoryFactor categoryFactor) {
        this.name = string;
        this.factor = categoryFactor;
        if (categoryFactor != null) {
            this.setColor(RtPerfectSpread.generateStringColor(categoryFactor.getTotalCount()));
        }
        this.uid = UniqueUID.getUniqueId();
    }

    public CatClass(Node node, CategoryFactor categoryFactor) {
        this.factor = categoryFactor;
        if (node.getAttributes().getLength() > 0) {
            String string;
            String string2;
            String string3;
            this.name = XmlParserHelper.getAttribute(node, "name");
            String string4 = XmlParserHelper.getAttribute(node, "id");
            this.uid = string4 != null ? string4 : this.name;
            String string5 = XmlParserHelper.getAttribute(node, "color");
            if (string5 == null) {
                string5 = this.parseLegacyColor(node);
            }
            if (string5 != null) {
                this.setColor(string5);
            }
            if ((string3 = XmlParserHelper.getAttribute(node, "index")) != null) {
                this.index = Integer.parseInt(string3);
            }
            if ((string2 = XmlParserHelper.getAttribute(node, "included")) != null) {
                this.included = Boolean.parseBoolean(string2);
            }
            if ((string = XmlParserHelper.getAttribute(node, "noclass")) != null) {
                this.noClass = true;
            }
            this.extraInfo = XmlParserHelper.getAttribute(node, "extraInfo");
            this.groupName = XmlParserHelper.getAttribute(node, "groupName");
            this.groupColor = XmlParserHelper.getAttribute(node, "groupColor");
            for (Node node2 : XmlParserHelper.getNodeList(node, "class")) {
                this.addSubClass(new CatClass(node2, categoryFactor));
            }
        } else {
            this.uid = this.name = node.getTextContent();
            if (categoryFactor != null) {
                this.setColor(RtPerfectSpread.generateStringColor(categoryFactor.getTotalCount()));
            }
        }
    }

    private String parseLegacyColor(Node node) {
        for (Node node2 : XmlParserHelper.parseChildNodes(node, "color")) {
            String string = node2.getTextContent();
            if (string.equals("NA")) continue;
            return string;
        }
        return null;
    }

    public CatClass clone() {
        return this.clone(this.factor);
    }

    public CatClass clone(CategoryFactor categoryFactor) {
        CatClass catClass = new CatClass(this.getName(), categoryFactor);
        catClass.uid = this.getUid();
        catClass.color = this.getColorString();
        catClass.index = this.getIndex();
        catClass.included = this.included;
        catClass.extraInfo = this.getExtraInfo();
        catClass.noClass = this.noClass;
        catClass.groupName = this.getGroupName();
        catClass.groupColor = this.getGroupColor();
        for (CatClass catClass2 : this.getSubClasses()) {
            catClass.addSubClass(catClass2.clone(categoryFactor));
        }
        return catClass;
    }

    public boolean equals(Object object) {
        if (this.name != null && object instanceof CatClass) {
            CatClass catClass = (CatClass)object;
            return this.name.equals(catClass.name) && this.color.equals(catClass.color);
        }
        return super.equals(object);
    }

    public Color getColor() {
        try {
            return RtPerfectSpread.getColorFromString(this.color);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getColorString() {
        return this.color;
    }

    public int getValueIdx() {
        if (this.index != null) {
            return this.index;
        }
        return this.factor.indexOf(this);
    }

    public int getClassIndex() {
        return this.factor.getClassIndex(this);
    }

    public void save(Element element) {
        Element element2 = XmlParserHelper.addElement(element, "class");
        element2.setAttribute("name", this.name);
        element2.setAttribute("id", this.getUid());
        element2.setAttribute("color", this.getColorString());
        if (this.index != null) {
            element2.setAttribute("index", this.index.toString());
        }
        if (this.included != null) {
            element2.setAttribute("included", this.included.toString());
        }
        if (this.isNoClass()) {
            element2.setAttribute("noclass", "");
        }
        if (this.getExtraInfo() != null) {
            element2.setAttribute("extraInfo", this.getExtraInfo());
        }
        if (this.getGroupColor() != null) {
            element2.setAttribute("groupColor", this.getGroupColor());
        }
        if (this.getGroupName() != null) {
            element2.setAttribute("groupName", this.getGroupName());
        }
        for (CatClass catClass : this.subClasses) {
            catClass.save(element2);
        }
    }

    public void setColor(Color color) {
        this.setColor(RtPerfectSpread.getColorToString(color));
    }

    public void setColor(String string) {
        this.color = string;
    }

    public String toString() {
        String string = this.getName();
        if (this.isIncluded()) {
            return string;
        }
        return string + "(e)";
    }

    public int getIndexOrZero() {
        if (this.index != null) {
            return this.index;
        }
        return 0;
    }

    public boolean isIncluded() {
        if (this.included != null) {
            return this.included;
        }
        return true;
    }

    public void addSubClass(CatClass catClass) {
        catClass.setParent(this);
        this.subClasses.add(catClass);
    }

    public boolean isNoClass() {
        return this.noClass || this.name.equals("-");
    }

    public boolean rootLevel() {
        return false;
    }

    public void forEveryClass(CategoryFactor.ClassCallback classCallback) {
        classCallback.withClass(this);
        this.getSubClasses().forEach(catClass -> catClass.forEveryClass(classCallback));
    }

    public static void render(Graphics graphics, CatClass catClass, int n) {
        CatClass.render(graphics, catClass, 10, n - 20);
    }

    public static void render(Graphics graphics, CatClass catClass, int n, int n2) {
        Color color;
        if (catClass != null && (color = catClass.getColor()) != null) {
            int n3 = Math.min(20, n2);
            graphics.setColor(color);
            graphics.fillRect(n, n, n3, n2);
            graphics.setColor(Color.black);
            graphics.drawRect(n, n, n3, n2);
        }
    }

    public void setNoClass() {
        this.noClass = true;
    }

    public boolean isGrouped() {
        return !this.subClasses.isEmpty();
    }

    public boolean hasChild(CatClass catClass) {
        return this.subClasses.contains(catClass);
    }

    public boolean isAdded() {
        return this.factor == null || "added".equalsIgnoreCase(this.extraInfo);
    }

    public static CatClass FromAdded(String string) {
        String[] stringArray = string.split("##", 3);
        CatClass catClass = new CatClass(stringArray[2], null);
        catClass.setColor(stringArray[1]);
        return catClass;
    }

    @Generated
    public CategoryFactor getFactor() {
        return this.factor;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String string) {
        this.name = string;
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public void setUid(String string) {
        this.uid = string;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public void setIndex(Integer n) {
        this.index = n;
    }

    @Generated
    public void setIncluded(Boolean bl) {
        this.included = bl;
    }

    @Generated
    public List<CatClass> getSubClasses() {
        return this.subClasses;
    }

    @Generated
    public CatClass getParent() {
        return this.parent;
    }

    @Generated
    public void setParent(CatClass catClass) {
        this.parent = catClass;
    }

    @Generated
    public String getExtraInfo() {
        return this.extraInfo;
    }

    @Generated
    public void setExtraInfo(String string) {
        this.extraInfo = string;
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    @Generated
    public void setGroupName(String string) {
        this.groupName = string;
    }

    @Generated
    public String getGroupColor() {
        return this.groupColor;
    }

    @Generated
    public void setGroupColor(String string) {
        this.groupColor = string;
    }
}

