/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.factor.category;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyseList;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorCache;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.util.IntHolder;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.common.util.raw.ExtraHeaderValues;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailClassification;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;

public class CategoryFactor
extends Factor<CategoryFactor>
implements Iterable<CatClass> {
    public static final String XML_NODENAME = "qualitative";
    private final List<CatClass> classList = new ArrayList<CatClass>();
    private CategoryBy categoryBy = CategoryBy.Manual;

    public CategoryFactor(NamedNodeMap namedNodeMap) {
        super(namedNodeMap);
        this.categoryBy = CategoryBy.parse(namedNodeMap.getNamedItem("by"));
    }

    public CategoryFactor(String string) {
        this(string, UniqueUID.getUniqueId());
        this.addNoClass("-", Color.red);
    }

    public CategoryFactor(String string, String string2) {
        super(string, string2);
    }

    @Override
    public Element save(Element element) {
        Element element2 = super.save(element);
        if (!this.categoryBy.equals((Object)CategoryBy.Manual)) {
            element2.setAttribute("by", this.categoryBy.name());
        }
        return element2;
    }

    public void addNoClass(String string, Color color) {
        CatClass catClass = this.addClass(string);
        catClass.setNoClass();
        catClass.setColor(color);
    }

    public void addClass(CatClass catClass) {
        this.classList.add(catClass);
    }

    public CatClass addClass(String string, Color color) {
        CatClass catClass = this.addClass(string);
        catClass.setColor(color);
        return catClass;
    }

    public CatClass addClass(String string) {
        if (!this.classExists(string)) {
            CatClass catClass = new CatClass(string, this);
            this.addClass(catClass);
            return catClass;
        }
        return this.getClass(string);
    }

    @Override
    public void appendXMLSettings(Element element) {
        for (CatClass catClass : this) {
            catClass.save(element);
        }
    }

    @Override
    public CategoryFactor clone() {
        CategoryFactor categoryFactor = new CategoryFactor(this.getName(), UniqueUID.getUniqueId());
        for (CatClass catClass : this) {
            categoryFactor.addClass(catClass.clone(categoryFactor));
        }
        return categoryFactor;
    }

    public CategoryFactor cloneLeafsKeepId() {
        CategoryFactor categoryFactor = new CategoryFactor(this.getName(), this.getUid());
        for (CatClass catClass : this.getLeafs()) {
            categoryFactor.addClass(catClass.clone(categoryFactor));
        }
        return categoryFactor;
    }

    public CatClass getClass(BasicSample basicSample) {
        if (this.isMissing(basicSample)) {
            if (this.classList.isEmpty()) {
                return null;
            }
            return this.classList.getFirst();
        }
        return this.getClassByValueIndx(basicSample);
    }

    public CatClass getClassByValueIndx(BasicSample basicSample) {
        Float f = basicSample.getSampleValues().getValue(this);
        if (f != null) {
            return this.getClassByValueIdx(f.intValue());
        }
        return null;
    }

    public int getClassIndex(String string) {
        CatClass catClass = this.getClass(string);
        if (catClass != null) {
            return this.getClassIndex(catClass);
        }
        return -1;
    }

    public int getClassIndex(CatClass catClass) {
        if (catClass == null) {
            return -1;
        }
        if (catClass.getIndex() != null) {
            return catClass.getIndex();
        }
        return this.indexOf(catClass);
    }

    public CatClass getClass(String string) {
        return this.getClass(this.classList, string, null);
    }

    public CatClass getClassByUid(String string) {
        for (CatClass catClass : this.classList) {
            if (!string.equals(catClass.getUid())) continue;
            return catClass;
        }
        return null;
    }

    public CatClass getClassByName(String string) {
        for (CatClass catClass : this.classList) {
            if (!string.equals(catClass.getName())) continue;
            return catClass;
        }
        return null;
    }

    public CatClass getClassByValueIdx(int n) {
        return this.getClass(this.classList, null, n);
    }

    private CatClass getClass(List<CatClass> list, String string, Integer n) {
        for (CatClass catClass : list) {
            if (string != null && catClass.getName().equalsIgnoreCase(string) || n != null && n.intValue() == catClass.getValueIdx()) {
                return catClass;
            }
            CatClass catClass2 = this.getClass(catClass.getSubClasses(), string, n);
            if (catClass2 == null) continue;
            return catClass2;
        }
        return null;
    }

    public int getClassCount() {
        return this.classList.size();
    }

    public int getTotalCount() {
        IntHolder intHolder = new IntHolder(0);
        this.forEveryClass(catClass -> intHolder.add(1));
        return intHolder.getValue();
    }

    public int getMaxSize() {
        return this.getMaxIndex() + 1;
    }

    public int getMaxIndex() {
        return this.getMinMaxIndex().max().intValue();
    }

    public MinMax getMinMaxIndex() {
        MinMax minMax = new MinMax();
        this.forEveryClass(catClass -> minMax.add(catClass.getValueIdx()));
        return minMax.checkEmpty();
    }

    public List<CatClass> getClasses() {
        return this.classList;
    }

    public int indexOf(CatClass catClass) {
        return this.classList.indexOf(catClass);
    }

    public Color getColor(BasicSample basicSample) {
        CatClass catClass = this.getClass(basicSample);
        if (catClass != null) {
            return catClass.getColor();
        }
        return null;
    }

    @Override
    public String getEntryString(BasicSample basicSample) {
        return this.getStringValue(basicSample);
    }

    @Override
    public float getFloatValue(String string) {
        for (CatClass catClass : this.classList) {
            if (!catClass.getName().equalsIgnoreCase(string)) continue;
            return catClass.getValueIdx();
        }
        return 0.0f;
    }

    @Override
    public String getStringValue(BasicSample basicSample, int n) {
        if (this.categoryBy.equals((Object)CategoryBy.Group)) {
            Measurement measurement = basicSample.measurement();
            Group group = measurement.getParent();
            CatClass catClass = this.getOrAddEntry(group);
            basicSample.getSampleValues().setValue(this, this.getClassIndex(catClass));
            return catClass.getName();
        }
        if (this.categoryBy.equals((Object)CategoryBy.Measurement)) {
            Measurement measurement = basicSample.measurement();
            CatClass catClass = this.getOrAddEntry(measurement);
            basicSample.getSampleValues().setValue(this, this.getClassIndex(catClass));
            return catClass.getName();
        }
        CatClass catClass = this.getClass(basicSample);
        if (catClass != null) {
            return catClass.getName();
        }
        return "-";
    }

    @Override
    public String getType() {
        return "Category";
    }

    @Override
    public Iterator<CatClass> iterator() {
        return this.classList.iterator();
    }

    @Override
    public void setValue(String string, BasicSample basicSample) {
        if (string != null && string.trim().length() > 0) {
            if (!this.classExists(string)) {
                this.addClass(string);
            }
            basicSample.getSampleValues().setValue(this, this.getFloatValue(string));
        } else {
            basicSample.getSampleValues().removeValue(this);
        }
    }

    private boolean classExists(String string) {
        for (CatClass catClass : this) {
            if (!catClass.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isMissing(BasicSample basicSample) {
        CatClass catClass;
        int n;
        Float f;
        if (basicSample != null && (f = basicSample.getSampleValues().getValue(this)) != null && (n = f.intValue()) < this.getClassCount() && (catClass = this.getClassByValueIdx(n)) != null) {
            return "-".equals(catClass.getName());
        }
        return true;
    }

    public int[][] createColorArray() {
        int[][] nArray = new int[this.getMaxSize()][4];
        this.forEveryClass(catClass -> CategoryFactor.setColorArray(nArray[catClass.getValueIdx()], catClass.getColor()));
        return nArray;
    }

    public int[][][] createClassColorIndexFromClassTypes(boolean bl, double d) {
        int[][][] nArray = new int[256][this.getMaxSize()][4];
        int n = nArray.length - 1;
        this.forEveryClass(catClass -> {
            int n2 = catClass.getValueIdx();
            Color color = catClass.getColor();
            CategoryFactor.setColorArray(nArray[n][n2], color);
            for (int i = 0; i < nArray.length - 1; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (bl) {
                        double d2 = (double)i / (double)nArray.length;
                        nArray[i][n2][j] = RtPerfectSpread.blendDark(nArray[n][n2][j], d2, d);
                        continue;
                    }
                    nArray[i][n2][j] = nArray[n][n2][j];
                }
                nArray[i][n2][3] = 255;
            }
        });
        return nArray;
    }

    public static void setColorArray(int[] nArray, Color color) {
        nArray[0] = color.getRed();
        nArray[1] = color.getGreen();
        nArray[2] = color.getBlue();
        nArray[3] = 255;
    }

    public static CategoryFactor parseCategoryFactor(Node node) {
        return CategoryFactor.parseCategoryFactor(node, true);
    }

    public static CategoryFactor parseCategoryFactor(Node node, boolean bl) {
        FactorCache factorCache = FactorCache.getInstance();
        NamedNodeMap namedNodeMap = node.getAttributes();
        CategoryFactor categoryFactor = (CategoryFactor)factorCache.getFactor(Factor.Type.Category, namedNodeMap, bl);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName().toLowerCase();
            if (!string.equals("class")) continue;
            categoryFactor.addClass(new CatClass(node2, categoryFactor));
        }
        return categoryFactor;
    }

    public static void syncAnalyseCategoryFactor(Node node, boolean bl) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("id");
        if (node2 != null && BreezeMasterCache.isInstanceMasterCache()) {
            Iterable<RtAnalyse> iterable;
            Object t = BreezeMasterCache.getInstance().getAnalyseList().byFactorId(node2.getNodeValue());
            if (t == null && (iterable = BreezeMasterCache.getRtAnalyseListOrNull()) != null) {
                t = ((BasicAnalyseList)iterable).byFactorId(node2.getNodeValue());
            }
            if (t != null && (iterable = ((BasicAnalyse)t).getCategoryFactor()) != null) {
                if (bl) {
                    ((CategoryFactor)iterable).removeAdded();
                }
                CategoryFactor categoryFactor = CategoryFactor.parseCategoryFactor(node, false);
                for (CatClass catClass : categoryFactor.getLeafs()) {
                    if (!catClass.isAdded()) continue;
                    CatClass catClass2 = ((CategoryFactor)iterable).getClass(catClass.getName());
                    if (catClass2 != null) {
                        catClass2.setName(catClass.getName());
                        catClass2.setColor(catClass.getColorString());
                        continue;
                    }
                    ((CategoryFactor)iterable).addClass(catClass);
                }
            }
        }
    }

    public void removeAdded() {
        for (int i = this.classList.size() - 1; i >= 0; --i) {
            if (!this.classList.get(i).isAdded()) continue;
            this.classList.remove(i);
        }
    }

    public CatClass group(List<CatClass> list) {
        return this.group(list, CategoryFactor.suggestName(list, ","));
    }

    public CatClass group(List<CatClass> list, String string) {
        this.forEveryClass(catClass -> catClass.setIndex(catClass.getValueIdx()));
        Integer n = this.getMaxSize();
        CatClass catClass2 = this.addClass(string);
        catClass2.setIndex(n);
        for (CatClass catClass3 : list) {
            if (catClass3.isNoClass()) continue;
            catClass2.addSubClass(catClass3);
            this.classList.remove(catClass3);
            catClass3.setIncluded(true);
        }
        return catClass2;
    }

    public void ungroup(CatClass catClass) {
        for (CatClass catClass2 : catClass.getSubClasses()) {
            Integer n = catClass2.getIndex();
            if (n != null) {
                int n2;
                for (n2 = 0; n2 < this.classList.size() && this.classList.get(n2).getValueIdx() <= n; ++n2) {
                }
                this.classList.add(n2, catClass2);
            } else {
                this.classList.add(catClass2);
            }
            catClass2.setParent(catClass.getParent());
        }
        this.classList.remove(catClass);
    }

    public String getClassificationString(int n) {
        CatClass catClass = this.getClassByValueIdx(n);
        if (catClass != null && catClass.isIncluded()) {
            return this.getRootClass(catClass).getName();
        }
        return "-";
    }

    public CatClass getRootClass(CatClass catClass) {
        CatClass catClass2 = catClass;
        while (catClass2.getParent() != null) {
            catClass2 = catClass2.getParent();
        }
        return catClass2;
    }

    public void syncAnalyseFactor(CategoryFactor categoryFactor) {
        Object object;
        Iterator<CatClass> iterator = this.classList.iterator();
        while (iterator.hasNext()) {
            CatClass catClass;
            object = categoryFactor.getClass((catClass = iterator.next()).getName());
            catClass.setIncluded(object != null && ((CatClass)object).isIncluded());
            if (object == null) continue;
            catClass.setExtraInfo(((CatClass)object).getExtraInfo());
        }
        for (CatClass catClass : categoryFactor.getClasses()) {
            CatClass catClass2;
            if (catClass.getSubClasses().isEmpty()) continue;
            object = new ArrayList();
            Object object2 = catClass.getSubClasses().iterator();
            while (object2.hasNext()) {
                catClass2 = object2.next();
                CatClass catClass3 = this.getClass(catClass2.getName());
                if (catClass3 == null) continue;
                ((ArrayList)object).add(catClass3);
            }
            if (((ArrayList)object).isEmpty() || (catClass2 = categoryFactor.getClass(((CatClass)(object2 = this.group((List<CatClass>)object, catClass.getName()))).getName())) == null) continue;
            ((CatClass)object2).setColor(catClass2.getColor());
            ((CatClass)object2).setExtraInfo(catClass2.getExtraInfo());
        }
    }

    public void syncModelFactor(CategoryFactor categoryFactor) {
        this.syncModelFactor(categoryFactor, true);
    }

    public void syncModelFactor(CategoryFactor categoryFactor, boolean bl) {
        CatClass catClass;
        this.setName(categoryFactor.getName());
        ArrayList<CatClass> arrayList = new ArrayList<CatClass>();
        for (CatClass catClass2 : categoryFactor) {
            catClass = this.getClassByUid(catClass2.getUid());
            if (catClass == null) {
                catClass = this.getClass(catClass2.getName());
            }
            if (catClass != null) {
                catClass.setName(catClass2.getName());
                catClass.setColor(catClass2.getColor());
                continue;
            }
            arrayList.add(catClass2);
        }
        for (CatClass catClass2 : arrayList) {
            catClass = catClass2.clone(this);
            if (bl) {
                catClass.setIncluded(false);
            }
            this.addClass(catClass);
        }
    }

    public void forEveryClass(ClassCallback classCallback) {
        this.getClasses().forEach(catClass -> catClass.forEveryClass(classCallback));
    }

    public HashMap<String, Short> getClassIndexHashMap() {
        HashMap<String, Short> hashMap = new HashMap<String, Short>();
        this.forEveryClass(catClass -> hashMap.put(catClass.getName(), (short)this.getClassIndex(catClass.getName())));
        return hashMap;
    }

    public List<CatClass> getAllClasses() {
        ArrayList<CatClass> arrayList = new ArrayList<CatClass>();
        this.forEveryClass(catClass -> arrayList.add(catClass));
        return arrayList;
    }

    public List<CatClass> getRealClasses() {
        ArrayList<CatClass> arrayList = new ArrayList<CatClass>();
        this.forEveryClass(catClass -> {
            if (!catClass.isNoClass()) {
                arrayList.add(catClass);
            }
        });
        return arrayList;
    }

    public List<CatClass> getLeafs() {
        ArrayList<CatClass> arrayList = new ArrayList<CatClass>();
        this.forEveryClass(catClass -> {
            if (catClass.getSubClasses().isEmpty()) {
                arrayList.add(catClass);
            }
        });
        return arrayList;
    }

    public List<CatClass> getLeafs(boolean[] blArray) {
        ArrayList<CatClass> arrayList = new ArrayList<CatClass>();
        IntHolder intHolder = new IntHolder();
        this.forEveryClass(catClass -> {
            if (catClass.getSubClasses().isEmpty() && blArray[intHolder.getValue()]) {
                arrayList.add(catClass);
            }
            intHolder.increase();
        });
        return arrayList;
    }

    public boolean isAllIncluded() {
        for (CatClass catClass : this.getAllClasses()) {
            if (catClass.isIncluded()) continue;
            return false;
        }
        return true;
    }

    public List<CatClass> getIncludedRoot() {
        ArrayList<CatClass> arrayList = new ArrayList<CatClass>();
        for (CatClass catClass : this.classList) {
            if (!catClass.isIncluded()) continue;
            arrayList.add(catClass);
        }
        return arrayList;
    }

    public int[] getRootMap() {
        int[] nArray = new int[this.getMaxSize()];
        for (CatClass catClass : this.getLeafs()) {
            nArray[catClass.getValueIdx()] = this.getRootClass(catClass).getValueIdx();
        }
        return nArray;
    }

    public int[] getLeftIndexMap() {
        int[] nArray = new int[this.getMaxSize()];
        int n = 0;
        for (CatClass catClass : this.getLeafs()) {
            nArray[catClass.getValueIdx()] = n++;
        }
        return nArray;
    }

    public void sortAccordingToIndex() {
        this.classList.sort(Comparator.comparing(CatClass::getIndexOrZero));
    }

    public static String suggestName(List<CatClass> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CatClass catClass : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(catClass.getName());
        }
        return stringBuilder.toString();
    }

    public static CategoryFactor indexColor(int n) {
        CategoryFactor categoryFactor = new CategoryFactor("Index color");
        for (int i = 0; i < n; ++i) {
            categoryFactor.addClass("" + (i + 1));
        }
        return categoryFactor;
    }

    public HashMap<Integer, Integer> getClassMap(CategoryFactor categoryFactor) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        this.forEveryClass(catClass -> hashMap.put(this.getClassIndex(catClass), categoryFactor.getClassIndex(catClass.getName())));
        return hashMap;
    }

    public void swap(int n, int n2) {
        CatClass catClass = this.classList.get(n);
        this.classList.set(n, this.classList.get(n2));
        this.classList.set(n2, catClass);
    }

    public void addExtraHeaderValues(ExtraHeaderValues extraHeaderValues) {
        List<CatClass> list = this.getAllClasses();
        extraHeaderValues.add("classes", String.valueOf(list.size()));
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (CatClass object : list) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            if (object.isNoClass()) {
                stringBuilder.append("Unclassified");
            } else {
                stringBuilder.append(object.getName());
            }
            bl = false;
        }
        extraHeaderValues.add("class names", stringBuilder.toString(), true);
        StringBuilder stringBuilder2 = new StringBuilder();
        bl = true;
        for (CatClass catClass : list) {
            if (!bl) {
                stringBuilder2.append(", ");
            }
            Color color = catClass.getColor();
            stringBuilder2.append(color.getRed());
            stringBuilder2.append(", ").append(color.getGreen());
            stringBuilder2.append(", ").append(color.getBlue());
            bl = false;
        }
        extraHeaderValues.add("class lookup", stringBuilder2.toString(), true);
    }

    @Override
    public Thumbnail createThumbnail(Measurement measurement, Sample sample, AbstractBreezeFunction abstractBreezeFunction, BasicAnalyse basicAnalyse, boolean bl, boolean bl2) {
        return new ThumbnailClassification(measurement, sample, basicAnalyse, this, bl, bl2, abstractBreezeFunction);
    }

    public List<CatClass> getGroupedClasses() {
        List<CatClass> list = this.getAllClasses();
        if (list.stream().anyMatch(CatClass::isGrouped)) {
            ArrayList<CatClass> arrayList = new ArrayList<CatClass>();
            HashSet<String> hashSet = new HashSet<String>();
            for (CatClass catClass : list) {
                if (hashSet.contains(catClass.getName())) continue;
                arrayList.add(catClass);
                hashSet.add(catClass.getName());
            }
            return arrayList;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public boolean synchronizeEntries(List<? extends Entry> list) {
        void var5_8;
        List<CatClass> list2 = this.getAllClasses();
        int n = this.getClassCount();
        for (Entry entry : list) {
            list2.remove(this.getOrAddEntry(entry));
        }
        boolean bl = n != this.getClassCount();
        int i = list2.size() - 1;
        while (var5_8 >= 0) {
            CatClass catClass = list2.get((int)var5_8);
            if (!catClass.isNoClass()) {
                this.classList.remove(catClass);
                bl = true;
            }
            --var5_8;
        }
        return bl;
    }

    private CatClass getOrAddEntry(Entry entry) {
        CatClass catClass = this.getClassByUid(entry.getUid());
        if (catClass == null) {
            catClass = this.getClass(entry.getName());
        }
        if (catClass != null) {
            catClass.setName(entry.getName());
        } else {
            catClass = this.addClass(entry.getName());
        }
        catClass.setUid(entry.getUid());
        return catClass;
    }

    public boolean isEditable() {
        return this.categoryBy.equals((Object)CategoryBy.Manual);
    }

    public boolean[] getIncluded(Measurement measurement) {
        boolean[] blArray = new boolean[this.getMaxSize()];
        for (Sample sample : measurement.getSamplesForCurrentLevel()) {
            int n;
            Float f = sample.getSampleValues().getValue(this);
            if (f == null || (n = f.intValue()) >= blArray.length) continue;
            blArray[n] = true;
        }
        return blArray;
    }

    public static CategoryFactor withNoClass(String string) {
        return CategoryFactor.withNoClass(string, UniqueUID.getUniqueId(), Color.red);
    }

    public static CategoryFactor withNoClass(String string, String string2) {
        return CategoryFactor.withNoClass(string, string2, Color.red);
    }

    public static CategoryFactor withNoClass(String string, String string2, Color color) {
        CategoryFactor categoryFactor = new CategoryFactor(string, string2);
        categoryFactor.addNoClass(BreezeProperties.getInstance().getDefaultNonClassifiedValue(), color);
        return categoryFactor;
    }

    @Generated
    public CategoryBy getCategoryBy() {
        return this.categoryBy;
    }

    @Generated
    public void setCategoryBy(CategoryBy categoryBy) {
        this.categoryBy = categoryBy;
    }

    public static enum CategoryBy {
        Manual("Manually"),
        Group("Automatic from group name"),
        Measurement("Automatic from measurement name");

        private final String description;

        private CategoryBy(String string2) {
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }

        public static CategoryBy parse(Node node) {
            if (node != null) {
                for (CategoryBy categoryBy : CategoryBy.values()) {
                    if (!categoryBy.name().equalsIgnoreCase(node.getTextContent())) continue;
                    return categoryBy;
                }
            }
            return Manual;
        }
    }

    public static interface ClassCallback {
        public void withClass(CatClass var1);
    }
}

