/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.factor.category;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.common.entry.factor.FactorList;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;

public class CategoryList
implements FactorList<CategoryFactor> {
    private final List<CategoryFactor> categories = new ArrayList<CategoryFactor>();
    private final FactorHolder holder;

    public CategoryList(FactorHolder factorHolder) {
        this.holder = factorHolder;
    }

    public CategoryFactor add(CategoryFactor categoryFactor) {
        if (this.holder.factorExistsByUID(categoryFactor.getUid())) {
            return null;
        }
        this.categories.add(categoryFactor);
        return categoryFactor;
    }

    public void addAll(CategoryList categoryList) {
        for (CategoryFactor categoryFactor : categoryList) {
            this.add(categoryFactor);
        }
    }

    @Override
    public void clear() {
        this.categories.clear();
    }

    @Override
    public CategoryFactor get(int n) {
        if (n < this.categories.size()) {
            return this.categories.get(n);
        }
        return null;
    }

    @Override
    public CategoryFactor getByUid(String string) {
        return (CategoryFactor)FactorHolder.getFactorByUid(string, this);
    }

    @Override
    public CategoryFactor getByOrigUid(String string) {
        return (CategoryFactor)FactorHolder.getFactorByOrigUid(string, this);
    }

    @Override
    public CategoryFactor getByName(String string) {
        return (CategoryFactor)FactorHolder.getFactorByName(string, this);
    }

    @Override
    public List<CategoryFactor> getList() {
        return this.categories;
    }

    @Override
    public int indexOf(Factor factor) {
        return this.categories.indexOf(factor);
    }

    public boolean isEmpty() {
        return this.categories.isEmpty();
    }

    @Override
    public Iterator<CategoryFactor> iterator() {
        return this.categories.iterator();
    }

    @Override
    public int size() {
        return this.categories.size();
    }

    public String toString() {
        return this.categories.toString();
    }
}

