/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.factor.property;

import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.sample.SampleValues;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.util.BreezeColor;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.entry.workflow.PropertyLimit;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailProperty;

public class PropertyFactor
extends Factor<PropertyFactor> {
    public static final String XML_NODENAME = "quantitative";
    private Float defaultValue = null;
    private String unit;

    public PropertyFactor(NamedNodeMap namedNodeMap) {
        super(namedNodeMap);
    }

    public PropertyFactor(String string) {
        this(string, UniqueUID.getUniqueId(), "%");
    }

    public PropertyFactor(String string, String string2) {
        this(string, string2, "%");
    }

    public PropertyFactor(String string, String string2, String string3) {
        super(string, string2);
        this.unit = string3;
    }

    @Override
    public void appendXMLSettings(Element element) {
        element.setAttribute("unit", this.getUnit());
        if (this.minMax != null) {
            XmlParserHelper.addElement((Node)element, "low", Float.toString(this.minMax.min().floatValue()));
            XmlParserHelper.addElement((Node)element, "high", Float.toString(this.minMax.max().floatValue()));
        }
        XmlParserHelper.addElement((Node)element, "default", this.defaultValue != null ? RtDataFormat.toString(this.defaultValue.floatValue()) : "");
    }

    @Override
    public PropertyFactor clone() {
        PropertyFactor propertyFactor = new PropertyFactor(this.getName());
        propertyFactor.setUnit(this.unit);
        propertyFactor.setMin(this.minMax.min().floatValue());
        propertyFactor.setMax(this.minMax.max().floatValue());
        propertyFactor.setDefaultValue(this.defaultValue);
        return propertyFactor;
    }

    public Float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getEntryString(BasicSample basicSample) {
        return this.getName() + " " + this.getStringValue(basicSample) + this.getUnit();
    }

    @Override
    public float getFloatValue(String string) {
        if (string != null) {
            double d = RtDataFormat.toNumber(string);
            return Double.isNaN(d) ? 0.0f : (float)d;
        }
        return 0.0f;
    }

    public Float getNormalisedFloatValue(BasicSample basicSample) {
        Float f = basicSample.getVariableValue(this);
        return this.getNormalisedFloatValue(f);
    }

    public Float getNormalisedFloatValue(Float f) {
        if (f != null) {
            return this.minMax.normalise(f.floatValue());
        }
        return null;
    }

    @Override
    public String getStringValue(BasicSample basicSample, int n) {
        SampleValues sampleValues = basicSample.getSampleValues();
        Float f = sampleValues.getValue(this);
        if (f != null) {
            return RtDataFormat.toString(f.floatValue(), n);
        }
        return "";
    }

    @Override
    public boolean isMissing(BasicSample basicSample) {
        return basicSample.getSampleValues().getValue(this) == null;
    }

    @Override
    public String getType() {
        return "Property";
    }

    public String getUnit() {
        return this.unit;
    }

    public void setDefaultValue(Float f) {
        this.defaultValue = f;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    @Override
    public void setValue(String string, BasicSample basicSample) {
        SampleValues sampleValues = basicSample.getSampleValues();
        if (string != null && string.length() > 0) {
            double d = RtDataFormat.toNumber(string);
            if (Double.isNaN(d)) {
                sampleValues.removeValue(this);
            } else {
                sampleValues.setValue(this, (float)d);
            }
        } else {
            sampleValues.removeValue(this);
        }
    }

    @Override
    public String toString() {
        if (this.unit != null && this.unit.length() > 0) {
            return this.getName() + " (" + this.unit + ")";
        }
        return this.getName();
    }

    public Color getColor(BasicSample basicSample, int[][] nArray) {
        Float f = this.getNormalisedFloatValue(basicSample);
        return PropertyFactor.getColor(f, nArray);
    }

    public static Color getColor(Float f, int[][] nArray) {
        int[] nArray2 = nArray[f != null ? BreezeColor.toRGB(f.floatValue()) : 0];
        return new Color(nArray2[0], nArray2[1], nArray2[2]);
    }

    public MinMax getMinMax(LimitConfiguration limitConfiguration) {
        if (limitConfiguration != null) {
            PropertyLimit propertyLimit = limitConfiguration.getWrapper(this);
            return propertyLimit != null ? propertyLimit.getMinMax() : this.getMinMax();
        }
        return this.getMinMax();
    }

    @Override
    public Thumbnail createThumbnail(Measurement measurement, Sample sample, AbstractBreezeFunction abstractBreezeFunction, BasicAnalyse basicAnalyse, boolean bl, boolean bl2) {
        return new ThumbnailProperty(measurement, sample, basicAnalyse, abstractBreezeFunction, this, ((ThumbnailDescriptor.ThumbnailQuantificationDescriptor)((Object)abstractBreezeFunction)).getSmooth(), bl, bl2);
    }

    public static PropertyFactor createConfidence() {
        PropertyFactor propertyFactor = new PropertyFactor("Confidence", "confidence");
        propertyFactor.setMax(1.0f);
        return propertyFactor;
    }
}

