/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.factor.property;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorCache;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.common.entry.factor.FactorList;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.util.RtDataFormat;

public class PropertyList
implements FactorList<PropertyFactor> {
    private final FactorHolder holder;
    private final List<PropertyFactor> properties = new ArrayList<PropertyFactor>();

    public PropertyList(FactorHolder factorHolder) {
        this.holder = factorHolder;
    }

    public PropertyFactor add(PropertyFactor propertyFactor) {
        if (this.holder.factorExistsByUID(propertyFactor.getUid())) {
            return null;
        }
        this.properties.add(propertyFactor);
        return propertyFactor;
    }

    public void addAll(PropertyList propertyList) {
        for (PropertyFactor propertyFactor : propertyList) {
            this.add(propertyFactor);
        }
    }

    @Override
    public PropertyFactor getByUid(String string) {
        return (PropertyFactor)FactorHolder.getFactorByUid(string, this.properties);
    }

    @Override
    public PropertyFactor getByOrigUid(String string) {
        return (PropertyFactor)FactorHolder.getFactorByOrigUid(string, this.properties);
    }

    @Override
    public PropertyFactor getByName(String string) {
        return (PropertyFactor)FactorHolder.getFactorByName(string, this.properties);
    }

    public PropertyFactor getByNameRemoveSpace(String string) {
        return (PropertyFactor)FactorHolder.getFactorByNameRemoveSpace(string, this.properties);
    }

    public static PropertyFactor parsePropertyFactor(Node node) {
        Object object;
        FactorCache factorCache = FactorCache.getInstance();
        NamedNodeMap namedNodeMap = node.getAttributes();
        PropertyFactor propertyFactor = (PropertyFactor)factorCache.getFactor(Factor.Type.Property, namedNodeMap, true);
        Node node2 = node.getAttributes().getNamedItem("unit");
        if (node2 != null) {
            object = node2.getNodeValue();
            propertyFactor.setUnit((String)object);
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            NodeList nodeList = node.getChildNodes();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Node node3 = nodeList.item(j);
                String string = node3.getNodeName().toLowerCase();
                if (string.equals("unit")) {
                    propertyFactor.setUnit(node3.getAttributes().getNamedItem("name").getNodeValue());
                    continue;
                }
                if (string.equals("low")) {
                    propertyFactor.setMin(RtDataFormat.toNumberFloat(node3.getTextContent()));
                    continue;
                }
                if (string.equals("high")) {
                    propertyFactor.setMax(RtDataFormat.toNumberFloat(node3.getTextContent()));
                    continue;
                }
                if (!string.equals("default")) continue;
                String string2 = node3.getTextContent();
                propertyFactor.setDefaultValue(string2.length() > 0 ? Float.valueOf(RtDataFormat.toNumberFloat(string2)) : null);
            }
        }
        return propertyFactor;
    }

    @Override
    public Iterator<PropertyFactor> iterator() {
        return this.properties.iterator();
    }

    @Override
    public List getList() {
        return this.properties;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public int indexOf(Factor factor) {
        return this.properties.indexOf(factor);
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public PropertyFactor get(int n) {
        if (n < this.properties.size()) {
            return this.properties.get(n);
        }
        return null;
    }

    public String toString() {
        return this.properties.toString();
    }

    public List<String> getVariableNames(BasicAnalyse basicAnalyse, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            PropertyFactor propertyFactor = this.getByName(string);
            if (propertyFactor == null) {
                throw new RuntimeException("Cannot find property factor for variable = " + string);
            }
            arrayList.add(basicAnalyse.getUid() + "_" + propertyFactor.getUid());
        }
        return arrayList;
    }
}

