/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.measurement;

import java.io.File;
import se.prediktera.breeze.entry.measurement.Measurement;

public interface MeasurementFileLocation {
    public File file(Measurement var1);

    public static class WhiteRef
    implements MeasurementFileLocation {
        @Override
        public final File file(Measurement measurement) {
            return new File(measurement.getFolder(), "whiteref_" + measurement.getBaseName() + ".raw");
        }

        public final File header(Measurement measurement) {
            return new File(measurement.getFolder(), "whiteref_" + measurement.getBaseName() + ".hdr");
        }
    }

    public static class DarkRef
    implements MeasurementFileLocation {
        @Override
        public final File file(Measurement measurement) {
            return new File(measurement.getFolder(), "darkref_" + measurement.getBaseName() + ".raw");
        }

        public final File header(Measurement measurement) {
            return new File(measurement.getFolder(), "darkref_" + measurement.getBaseName() + ".hdr");
        }
    }

    public static class Prediction
    implements MeasurementFileLocation {
        @Override
        public final File file(Measurement measurement) {
            return new File(measurement.getFolder(), measurement.getBaseName() + "_prediction.raw");
        }

        public final File header(Measurement measurement) {
            return new File(measurement.getFolder(), measurement.getBaseName() + "_prediction.hdr");
        }
    }

    public static class Image
    implements MeasurementFileLocation {
        @Override
        public final File file(Measurement measurement) {
            String string;
            File file = measurement.getFolder();
            File file2 = new File(file, (string = measurement.getBaseName()) + "_raw.png");
            if (file2.exists()) {
                return file2;
            }
            File file3 = new File(file, string + ".png");
            if (file3.exists()) {
                return file3;
            }
            return new File(file, string + ".jpg");
        }

        public final File png(Measurement measurement) {
            return new File(measurement.getFolder(), measurement.getBaseName() + ".png");
        }

        public final File jpg(Measurement measurement) {
            return new File(measurement.getFolder(), measurement.getBaseName() + ".jpg");
        }
    }

    public static class Raw
    implements MeasurementFileLocation {
        @Override
        public final File file(Measurement measurement) {
            return new File(measurement.getFolder(), measurement.getBaseName() + "." + measurement.getBaseExt());
        }

        public final File header(Measurement measurement) {
            return new File(measurement.getFolder(), measurement.getBaseName() + ".hdr");
        }
    }
}

