/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.sample;

import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.ObjectWithChildrenAndParent;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.sample.SampleValues;
import se.prediktera.breeze.common.entry.sample.TrackInformation;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorHolder;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.image.RtPixel2D;
import se.prediktera.breeze.common.util.image.RtSpatialObject;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.SamplePath;

public abstract class BasicSample
implements ObjectWithChildrenAndParent<BasicSample, BasicSample>,
DescriptorInterface {
    private BasicSample parent;
    private final List<BasicSample> childList = new ArrayList<BasicSample>();
    private int childIndex;
    private final DescriptorHolder descriptorHolder = new DescriptorHolder(this);
    private final SampleValues sampleValues = new SampleValues();
    private RtSpatialObject cachedSpatialObject;
    private TrackInformation trackInformation;
    private long index;

    public String getName() {
        return null;
    }

    public Float getVariableValue(Factor factor) {
        return this.sampleValues.getValue(factor);
    }

    public SampleValues getSampleValues() {
        return this.sampleValues;
    }

    @Override
    public DescriptorHolder getDescriptorHolder() {
        return this.descriptorHolder;
    }

    @Override
    public final float getDescriptorValue(DescriptorTreeNode descriptorTreeNode) {
        return this.descriptorHolder.getDescriptorValue(descriptorTreeNode);
    }

    @Override
    public final FunctionResult getFunctionResult(String string) {
        return this.descriptorHolder.getFunctionResult(string);
    }

    @Override
    public final void putFunctionResult(String string, FunctionResult functionResult) {
        this.descriptorHolder.putFunctionResult(string, functionResult);
    }

    public void setCachedSpatialObject(RtSpatialObject rtSpatialObject) {
        this.cachedSpatialObject = rtSpatialObject;
    }

    public SamplePath getSamplePath() {
        return null;
    }

    public abstract List<SamplePath.SelectionPath> getSelectionPaths();

    public abstract void setSelectionPath(int[][] var1);

    public abstract List<RtPixel2D> getObjectPixels();

    public abstract float[][] getAverageProfiles();

    public abstract void setAverageProfiles(float[][] var1);

    public abstract Shape getOrCreateGeneralPath();

    public void clearObjectCache() {
        this.cachedSpatialObject = null;
    }

    public void setTrackInformation(TrackInformation trackInformation) {
        this.trackInformation = trackInformation;
    }

    public TrackInformation getTrackInformation() {
        return this.trackInformation;
    }

    public RtSpatialObject getCachedSpatialObject() {
        return this.cachedSpatialObject;
    }

    public void setParent(BasicSample basicSample) {
        this.parent = basicSample;
    }

    @Override
    public BasicSample getParent() {
        return this.parent;
    }

    @Override
    public final BasicSample addChild(BasicSample basicSample) {
        basicSample.setParent(this);
        this.childList.add(basicSample);
        basicSample.index = this.childIndex++;
        return basicSample;
    }

    public final BasicSample addChild(int n, BasicSample basicSample) {
        basicSample.setParent(this);
        this.childList.add(n, basicSample);
        basicSample.index = this.childIndex++;
        return basicSample;
    }

    public BasicSample getChild(int n) {
        return this.childList.get(n);
    }

    @Override
    public int getChildIndex(BasicSample basicSample) {
        return this.childList.indexOf(basicSample);
    }

    @Override
    public int getChildCount() {
        return this.childList.size();
    }

    public List<BasicSample> getChildList() {
        return this.childList;
    }

    @Override
    public void removeChild(BasicSample basicSample) {
        this.childList.remove(basicSample);
    }

    public boolean hasSample(BasicSample basicSample) {
        return this.childList.contains(basicSample);
    }

    public RtFrame createRtFrameFromProfile() {
        float[][] fArray = this.getAverageProfiles();
        BandNames bandNames = BandNames.fromIndex(fArray[0].length);
        return this.createRtFrameFromProfile(bandNames);
    }

    public RtFrame createRtFrameFromProfile(BandNames bandNames) {
        float[][] fArray = this.getAverageProfiles();
        RtFrame rtFrame = new RtFrame(new BandCount(fArray[0].length), new PixelWidth(1), bandNames, 1);
        for (int i = 0; i < fArray[0].length; ++i) {
            rtFrame.setFrameValue(i, 0, fArray[0][i]);
        }
        return rtFrame;
    }

    public boolean isRoot() {
        return false;
    }

    public void forEverySample(SampleCallback sampleCallback) {
        sampleCallback.withSample(this);
        this.getChildList().forEach(basicSample -> basicSample.forEverySample(sampleCallback));
    }

    public String getSegmentationHashId() {
        return "";
    }

    public Measurement measurement() {
        return null;
    }

    public BasicSample getRoot() {
        BasicSample basicSample = this;
        while (!basicSample.isRoot()) {
            basicSample = basicSample.getParent();
        }
        return basicSample;
    }

    public long getIndex() {
        return this.index;
    }

    public int getSegmentationLevel() {
        int n = 0;
        for (BasicSample basicSample = this; basicSample != null && !basicSample.isRoot(); basicSample = basicSample.getParent()) {
            ++n;
        }
        return n;
    }

    public int getIndex(String string) {
        int n = 0;
        BasicSample basicSample = this.getParent();
        if (basicSample != null) {
            BasicSample basicSample2 = basicSample.getParent();
            if (basicSample2 != null) {
                for (BasicSample basicSample3 : basicSample2.getChildList()) {
                    if (basicSample3 == basicSample) break;
                    for (BasicSample basicSample4 : basicSample3.getChildList()) {
                        if (!string.equals(basicSample4.getSegmentationHashId())) continue;
                        ++n;
                    }
                }
            }
            for (BasicSample basicSample3 : basicSample.getChildList()) {
                if (basicSample3 == this) break;
                if (!string.equals(basicSample3.getSegmentationHashId())) continue;
                ++n;
            }
        }
        return n;
    }

    public static interface SampleCallback {
        public void withSample(BasicSample var1);
    }
}

