/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.analysistree;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.model.ConnectionDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AddParameter;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.image.RtObjectValues;
import se.prediktera.breeze.common.util.image.RtSpatialObject;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;

public class DescriptorTreeNode
extends FunctionTreeNodeWithId
implements FactorOrDescriptor {
    private AbstractBreezeFunction function;
    private int index;

    public DescriptorTreeNode(String string) {
        super(string);
    }

    public DescriptorTreeNode() {
    }

    @Override
    public void calculateDescriptors(BreezeProgress breezeProgress, HashMap<AbstractBreezeFunction, float[]> hashMap, DescriptorInterface descriptorInterface, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject) {
        float[] fArray;
        FunctionResult functionResult;
        AbstractDescriptor abstractDescriptor = (AbstractDescriptor)this.function;
        boolean bl = abstractDescriptor.childDescriptorsAreInput();
        if (bl) {
            super.calculateDescriptors(breezeProgress, hashMap, descriptorInterface, rtFramesAndRefs, rtSpatialObject);
        }
        if ((functionResult = descriptorInterface.getFunctionResult(this.getUid())) == null) {
            functionResult = new FunctionResult(this);
            descriptorInterface.putFunctionResult(this.getUid(), functionResult);
        }
        if ((fArray = hashMap.get(abstractDescriptor)) == null) {
            fArray = abstractDescriptor.perform(breezeProgress, this, descriptorInterface, rtFramesAndRefs, rtSpatialObject);
            hashMap.put(abstractDescriptor, fArray);
        }
        if (fArray != null) {
            functionResult.setValue(fArray[this.index]);
        }
        if (!bl) {
            super.calculateDescriptors(breezeProgress, hashMap, descriptorInterface, rtFramesAndRefs, rtSpatialObject);
        }
    }

    @Override
    public String getAliasOrNodeString(FunctionTreeNode.TextType textType) {
        Object object = this.function;
        if (object instanceof AddParameter.AddFunctionWithAliasInterface) {
            AddParameter.AddFunctionWithAliasInterface addFunctionWithAliasInterface = (AddParameter.AddFunctionWithAliasInterface)object;
            object = addFunctionWithAliasInterface.getRootAlias(this);
            String string = this.function.getNodeString(this, this.index, textType);
            if (textType.equals((Object)FunctionTreeNode.TextType.Normal)) {
                Object object2 = object != null ? object : string;
                int n = AddParameter.AddNodeList.getNumberIncluded(this, addFunctionWithAliasInterface);
                if (n > 0) {
                    return (String)object2 + " (+" + n + ")";
                }
                return object2;
            }
            return string;
        }
        return super.getAliasOrNodeString(textType);
    }

    @Override
    public DescriptorTreeNode clone(boolean bl) {
        DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)super.clone(bl);
        if (this.function != null) {
            descriptorTreeNode.function = this.function.clone();
            descriptorTreeNode.function.setNode(descriptorTreeNode);
        }
        return descriptorTreeNode;
    }

    @Override
    public double evaluate(DescriptorInterface descriptorInterface) {
        return this.getValue(descriptorInterface);
    }

    @Override
    public void getDescriptors(List<DescriptorTreeNode> list) {
        if (!this.isHieararchyConnectionDescriptor()) {
            list.add(this);
        }
        super.getDescriptors(list);
    }

    public boolean isHieararchyConnectionDescriptor() {
        return !ConnectionDescriptor.getHieararchyConnectionDescriptorType(this).isVisible();
    }

    @Override
    public AbstractBreezeFunction getFunction() {
        return this.function;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public String getUnit() {
        return this.function.getUnit(this, this.index);
    }

    public void setIndex(int n) {
        this.index = n;
    }

    @Override
    public String getNodeString(FunctionTreeNode.TextType textType) {
        return this.function.getNodeString(this, this.index, textType);
    }

    @Override
    public String getShapeType() {
        if (this.function != null) {
            return this.function.getShapeType();
        }
        return "descriptor";
    }

    public String getType() {
        if (this.function != null) {
            return this.function.getName();
        }
        return null;
    }

    private float getValue(DescriptorInterface descriptorInterface) {
        FunctionResult functionResult = descriptorInterface.getFunctionResult(this.getUid());
        if (functionResult != null) {
            return functionResult.getValue();
        }
        return 0.0f;
    }

    @Override
    public void parse(Node node) {
        super.parse(node);
        String string = XmlParserHelper.getAttribute(node, "output");
        if (string != null) {
            this.index = this.function.getIndexFromType(string);
        }
        this.function.parse(node);
    }

    @Override
    public Node save(Node node) {
        Element element = (Element)super.save(node);
        this.function.save(element);
        if (this.index >= 0) {
            String string = this.function.getOutputString(this.index);
            XmlParserHelper.setAttribute((Node)element, "output", string);
        }
        return element;
    }

    @Override
    public void setFunction(AbstractBreezeFunction abstractBreezeFunction) {
        this.function = abstractBreezeFunction;
        abstractBreezeFunction.setNode(this);
        this.index = 0;
    }

    @Override
    public void addToolTipText(Workflow workflow, StringBuffer stringBuffer) {
        if (this.function != null && this.index >= 0) {
            this.function.addToolTipText(workflow, this, stringBuffer);
            String[] stringArray = this.function.getOutputs();
            if (stringArray != null && stringArray.length > 1) {
                String string = this.function.getOutputString(this.index);
                if (string.length() > 0) {
                    stringBuffer.append("@Output = " + string);
                } else if (stringArray != null) {
                    stringBuffer.append("@Output = " + stringArray[this.index]);
                }
            }
        }
    }

    public String toString() {
        if (this.function != null) {
            if (this.index >= 0) {
                String string = this.function.getOutputString(this.index);
                if (string.length() > 0) {
                    return this.function.toString() + "@" + string;
                }
                String[] stringArray = this.function.getOutputs();
                if (stringArray != null) {
                    return this.function.toString() + "@" + stringArray[this.index];
                }
            }
            return this.function.toString();
        }
        return super.toString();
    }

    public boolean hasParentSimilarAnalyse() {
        Object object = this.getParent();
        if (object instanceof DescriptorTreeNode) {
            DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)object;
            object = descriptorTreeNode.getAnalyseUid();
            String string = this.getAnalyseUid();
            return object != null && ((String)object).equals(string);
        }
        return false;
    }

    public String getSummaryViewGroupName() {
        return this.getFunction().getGroup();
    }

    public boolean equalAnalyseAndFactor(String string, String string2, AdditionalFactor additionalFactor) {
        String string3 = this.getAnalyseUid();
        if (string3 != null && !string3.equals(string)) {
            return false;
        }
        if (additionalFactor != null) {
            return additionalFactor.getUid().equals(string2);
        }
        String string4 = this.getFactorUid();
        return string4 != null && string4.equals(string2);
    }

    public void addObjectModes(Set<RtObjectValues.ObjectMode> set) {
        if (this.function instanceof SpatialDescriptor) {
            if (SpatialDescriptor.Unit.values()[this.index].requireRadius()) {
                set.add(RtObjectValues.ObjectMode.Radius);
            }
            if (SpatialDescriptor.Unit.values()[this.index].requireRotation()) {
                set.add(RtObjectValues.ObjectMode.Rotation);
            }
            if (SpatialDescriptor.Unit.values()[this.index].requireBorder()) {
                set.add(RtObjectValues.ObjectMode.Border);
            }
        }
    }

    @Override
    public String getName() {
        return this.getAliasOrNodeString();
    }

    @Override
    public Float getValue(BasicSample basicSample) {
        if (basicSample.getDescriptorHolder().hasDescriptorValue(this)) {
            return Float.valueOf(basicSample.getDescriptorValue(this));
        }
        return null;
    }

    @Override
    public String getOrigUid() {
        return this.getUid();
    }

    @Override
    public Factor cloneKeepId() {
        return new PropertyFactor(this.getName(), this.getUid(), "");
    }

    @Override
    public List<AdditionalFactor> getAdditionalFactors() {
        if (this.function != null) {
            return this.function.getAdditionalFactors();
        }
        return null;
    }

    public DescriptorTreeNode getHierarchyNode(Sample sample, boolean bl) {
        return PlsPredQuantificationDescriptor.ConnectedQuantificationFunctionResult.getHierarchyNode(this, sample, bl);
    }
}

