/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.analysistree;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPImportEvinceModel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPImportModel;
import se.prediktera.breeze.frontend.main.model.ModelMainPanel;
import se.prediktera.breeze.frontend.wizard.model.ClassificationModelWizard;
import se.prediktera.breeze.frontend.wizard.model.ClassificationRuntimeModelWizard;
import se.prediktera.breeze.frontend.wizard.model.ClassificationSimcaModelWizard;
import se.prediktera.breeze.frontend.wizard.model.CurveSeparationModelWizard;
import se.prediktera.breeze.frontend.wizard.model.QuantificationModelWizard;
import se.prediktera.breeze.frontend.wizard.model.QuantificationRuntimeModelWizard;
import se.prediktera.breeze.frontend.wizard.model.SampleModelWizard;

public class ModelListHelper {
    public static List<AbstractCardInfo> getModelTypesSorted(Workflow workflow) {
        BandCount bandCount;
        ArrayList<AbstractCardInfo> arrayList = new ArrayList<AbstractCardInfo>();
        arrayList.add(new SampleModelWizard.Info());
        arrayList.add(new QuantificationModelWizard.Info());
        arrayList.add(new ClassificationModelWizard.Info());
        arrayList.add(new ClassificationSimcaModelWizard.Info());
        arrayList.add(new QuantificationRuntimeModelWizard.Info());
        arrayList.add(new ClassificationRuntimeModelWizard.Info());
        Measurement measurement = workflow.getFirstMeasurementWithData();
        if (measurement != null && (bandCount = measurement.getBandCount()) instanceof BandCount) {
            BandCount bandCount2 = bandCount;
            if (bandCount2.value == 2) {
                arrayList.add(new CurveSeparationModelWizard.Info());
            }
        }
        arrayList.add(new ImportModelCard());
        arrayList.add(new ImportEvinceCard());
        return arrayList;
    }

    public static class ImportModelCard
    extends AbstrtactImportCard {
        @Override
        public String getDescription() {
            return "Import existing models into Breeze";
        }

        @Override
        public List<String> getKeywords() {
            return List.of("model");
        }

        @Override
        public BreezeMainPanel createWizard(ModelMainPanel modelMainPanel, Object object) {
            return new PPImportModel(modelMainPanel, "Import model");
        }
    }

    public static class ImportEvinceCard
    extends AbstrtactImportCard {
        @Override
        public String getImageIcon() {
            return "evince";
        }

        @Override
        public String getShortName() {
            return "From Evince";
        }

        @Override
        public String getDescription() {
            return "Import Evince model into Breeze";
        }

        @Override
        public List<String> getKeywords() {
            return List.of("evince", "map");
        }

        @Override
        public BreezeMainPanel createWizard(ModelMainPanel modelMainPanel, Object object) {
            return new PPImportEvinceModel(modelMainPanel, "Import Evince model", object);
        }
    }

    public static abstract class AbstrtactImportCard
    implements AbstractCardInfo {
        @Override
        public String getImageIcon() {
            return "import";
        }

        @Override
        public String getHelp() {
            return "";
        }

        @Override
        public String getShortDescription() {
            return this.getShortName();
        }

        @Override
        public String getShortName() {
            return "Import";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Import;
        }

        public abstract BreezeMainPanel createWizard(ModelMainPanel var1, Object var2);
    }
}

