/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.analysistree;

import java.util.Objects;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;

public class SegmentationIdentifier {
    public Integer Level = -1;
    public String HashId = null;

    public int hashCode() {
        return Objects.hash(this.Level, this.HashId);
    }

    public SegmentationIdentifier() {
    }

    public SegmentationIdentifier(int n, String string) {
        this.Level = n;
        this.HashId = string;
    }

    public SegmentationIdentifier(Node node) {
        this.HashId = XmlParserHelper.getAttribute(node, "uid");
        String string = XmlParserHelper.getAttribute(node, "level");
        if (string != null) {
            this.Level = Integer.parseInt(string);
        }
    }

    public void save(Node node) {
        Element element = XmlParserHelper.addElement(node, "segmentation");
        if (this.HashId != null) {
            element.setAttribute("uid", this.HashId);
        }
        element.setAttribute("level", String.valueOf(this.Level));
    }

    public boolean levelChanged(int n) {
        return this.Level < 0 || this.Level > n;
    }

    public void setLevel(int n) {
        this.Level = n;
        this.HashId = null;
    }

    public boolean equals(Object object) {
        if (object instanceof SegmentationIdentifier) {
            SegmentationIdentifier segmentationIdentifier = (SegmentationIdentifier)object;
            if (segmentationIdentifier.HashId != null && this.HashId != null) {
                return segmentationIdentifier.HashId.equals(this.HashId);
            }
            return Objects.equals(segmentationIdentifier.Level, this.Level);
        }
        return super.equals(object);
    }
}

