/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.analysistree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.tree.analysistree.DefaultSegmentationPort;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationPort;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.model.AbstractModelSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.model.ModelSegmentation;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.image.RtSpatialObject;
import se.prediktera.breeze.entry.workflow.Workflow;

public class SegmentationNode
extends FunctionTreeNodeWithId {
    private AbstractSegmentation function;

    public SegmentationNode(String string) {
        super(string);
    }

    public SegmentationNode() {
    }

    @Override
    public double evaluate(DescriptorInterface descriptorInterface) {
        return 0.0;
    }

    @Override
    public AbstractSegmentation getFunction() {
        return this.function;
    }

    @Override
    public String getNodeString(FunctionTreeNode.TextType textType) {
        if (this.function != null) {
            return this.function.getNodeString(this, -1, FunctionTreeNode.TextType.Normal);
        }
        return "";
    }

    @Override
    public String getShapeType() {
        if (this.function != null && this.function.isInverse()) {
            return "segmentate_bg";
        }
        return "segmentate";
    }

    @Override
    public boolean isComparison() {
        if (this.function != null) {
            return this.function.isComparison();
        }
        return super.isComparison();
    }

    @Override
    public SegmentationNode clone(boolean bl) {
        SegmentationNode segmentationNode = (SegmentationNode)super.clone(bl);
        if (this.function != null) {
            segmentationNode.function = (AbstractSegmentation)this.function.clone();
        }
        return segmentationNode;
    }

    @Override
    public void parse(Node node) {
        super.parse(node);
        this.function.parse(node);
    }

    @Override
    public Node save(Node node) {
        Element element = (Element)super.save(node);
        this.function.save(element);
        return element;
    }

    @Override
    public void setFunction(AbstractBreezeFunction abstractBreezeFunction) {
        this.function = (AbstractSegmentation)abstractBreezeFunction;
        this.function.setNode(this);
    }

    public void recreateSegmentationPorts(Workflow workflow) {
        if (this.function != null) {
            if (this.function instanceof AbstractModelSegmentation) {
                ((AbstractModelSegmentation)this.function).setDefaultAnalyseParameterValueIfNeeded(workflow);
            }
            List<FunctionTreeNode> list = this.getChildList();
            Object[] objectArray = this.function.getClasses();
            if (objectArray.length > 0 && objectArray.length == list.size() && list.get(0) instanceof SegmentationPort) {
                for (int i = 0; i < objectArray.length; ++i) {
                    list.get(i).setAlias(objectArray[i].toString());
                }
                return;
            }
            this.setChildList(new ArrayList<FunctionTreeNode>());
            FunctionTreeNode functionTreeNode = null;
            for (Object object : objectArray) {
                DefaultSegmentationPort.Info info = new DefaultSegmentationPort.Info();
                functionTreeNode = info.createNode();
                functionTreeNode.setFunction(((AbstractBreezeFunctionInfo)info).createFunction());
                functionTreeNode.setAlias(object.toString());
                this.addChild(functionTreeNode);
            }
            if (functionTreeNode != null) {
                for (FunctionTreeNode functionTreeNode2 : list) {
                    if (functionTreeNode2 instanceof SegmentationPort) {
                        for (FunctionTreeNode functionTreeNode3 : functionTreeNode2.getChildList()) {
                            functionTreeNode.addChild(functionTreeNode3);
                        }
                        continue;
                    }
                    functionTreeNode.addChild(functionTreeNode2);
                }
            }
        }
    }

    @Override
    public void replaceWith(FunctionTreeNode functionTreeNode) {
        if (!(functionTreeNode instanceof SegmentationNode)) {
            SegmentationPort segmentationPort = this.getDefaultPort();
            this.setChildList(segmentationPort.getChildList());
        }
        super.replaceWith(functionTreeNode);
    }

    @Override
    public void addToolTipText(Workflow workflow, StringBuffer stringBuffer) {
        if (this.function != null) {
            this.function.addToolTipText(workflow, this, stringBuffer);
        }
    }

    public String toString() {
        if (this.function != null) {
            return this.function.toString();
        }
        return super.toString();
    }

    @Override
    public void calculateDescriptors(BreezeProgress breezeProgress, HashMap<AbstractBreezeFunction, float[]> hashMap, DescriptorInterface descriptorInterface, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject) {
    }

    public boolean isCalculateAverages() {
        return this.function.isCalculateAverages();
    }

    @Override
    public boolean isManualAdd() {
        return true;
    }

    public SegmentationPort getDefaultPort() {
        if (this.getLastTreeNode() instanceof SegmentationPort) {
            return (SegmentationPort)this.getLastTreeNode();
        }
        this.recreateSegmentationPorts(null);
        if (this.getLastTreeNode() instanceof SegmentationPort) {
            return (SegmentationPort)this.getLastTreeNode();
        }
        return null;
    }

    private FunctionTreeNode getLastTreeNode() {
        if (this.getChildCount() > 0) {
            return this.getChild(this.getChildCount() - 1);
        }
        return null;
    }

    @Override
    public List<DescriptorTreeNode> getDescriptorNodes(boolean bl) {
        return this.getDefaultPort().getDescriptorNodes(bl);
    }

    public static SegmentationNode createDefault() {
        SegmentationNode segmentationNode = (SegmentationNode)FunctionHelper.createNew(new ModelSegmentation.Info());
        segmentationNode.recreateSegmentationPorts(null);
        return segmentationNode;
    }

    public static List<SegmentationNode> getSegmentationNodes(FunctionTreeNode functionTreeNode) {
        ArrayList<SegmentationNode> arrayList = new ArrayList<SegmentationNode>();
        SegmentationNode segmentationNode = SegmentationNode.getNextSegmentationNode(functionTreeNode);
        while (segmentationNode != null) {
            arrayList.add(segmentationNode);
            SegmentationNode segmentationNode2 = SegmentationNode.getNextSegmentationNode(segmentationNode);
            if (segmentationNode2 == null) break;
            segmentationNode = segmentationNode2;
        }
        return arrayList;
    }

    public static SegmentationNode getLastSegmentationNode(FunctionTreeNode functionTreeNode) {
        ArrayList<SegmentationNode> arrayList = new ArrayList<SegmentationNode>();
        SegmentationNode.addSegmentationsRecursive(arrayList, functionTreeNode);
        if (arrayList.size() > 0) {
            arrayList.sort(new Comparator<SegmentationNode>(){

                @Override
                public int compare(SegmentationNode segmentationNode, SegmentationNode segmentationNode2) {
                    return Integer.compare(SegmentationNode.getSegmentationLevel(segmentationNode), SegmentationNode.getSegmentationLevel(segmentationNode2));
                }
            });
            return arrayList.get(arrayList.size() - 1);
        }
        return null;
    }

    public static SegmentationNode getNextSegmentationNode(FunctionTreeNode functionTreeNode) {
        List<SegmentationNode> list = SegmentationNode.getSegmentations(functionTreeNode);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static List<SegmentationNode> getSegmentations(FunctionTreeNode functionTreeNode) {
        ArrayList<SegmentationNode> arrayList = new ArrayList<SegmentationNode>();
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            if (functionTreeNode2 instanceof SegmentationNode) {
                SegmentationNode segmentationNode = (SegmentationNode)functionTreeNode2;
                arrayList.add(segmentationNode);
                continue;
            }
            if (!(functionTreeNode2 instanceof SegmentationPort)) continue;
            for (FunctionTreeNode functionTreeNode3 : functionTreeNode2.getChildList()) {
                if (!(functionTreeNode3 instanceof SegmentationNode)) continue;
                SegmentationNode segmentationNode = (SegmentationNode)functionTreeNode3;
                arrayList.add(segmentationNode);
            }
        }
        return arrayList;
    }

    public static List<SegmentationNode> addSegmentationsRecursive(List<SegmentationNode> list, FunctionTreeNode functionTreeNode) {
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            if (functionTreeNode2 instanceof SegmentationNode) {
                list.add((SegmentationNode)functionTreeNode2);
            }
            SegmentationNode.addSegmentationsRecursive(list, functionTreeNode2);
        }
        return list;
    }

    public static int getSegmentationLevel(FunctionTreeNode functionTreeNode) {
        int n = 0;
        if (functionTreeNode != null) {
            FunctionTreeNode functionTreeNode2 = functionTreeNode;
            while (functionTreeNode2.getParent() instanceof FunctionTreeNode) {
                FunctionTreeNode functionTreeNode3 = functionTreeNode2.getParent();
                if (functionTreeNode3 instanceof SegmentationNode || !(functionTreeNode3.getParent() instanceof FunctionTreeNode)) {
                    ++n;
                }
                functionTreeNode2 = functionTreeNode3;
            }
        }
        return n;
    }

    public static String getSegmentationHashId(FunctionTreeNode functionTreeNode) {
        if (functionTreeNode instanceof SegmentationNode) {
            SegmentationNode segmentationNode = (SegmentationNode)functionTreeNode;
            return segmentationNode.getUid();
        }
        return "";
    }

    public static FunctionTreeNode getParentNode(FunctionTreeNode functionTreeNode) {
        while (functionTreeNode != null) {
            FunctionTreeNode functionTreeNode2 = functionTreeNode.getParent();
            if (functionTreeNode2 instanceof SegmentationPort) {
                return ((SegmentationPort)functionTreeNode2).getSegmentationNode();
            }
            if (functionTreeNode2 instanceof SegmentationNode) {
                return functionTreeNode2;
            }
            if (functionTreeNode2 == null) {
                return functionTreeNode;
            }
            functionTreeNode = functionTreeNode2;
        }
        return null;
    }

    public static FunctionTreeNode getParentNodeOrDefaultPort(FunctionTreeNode functionTreeNode) {
        FunctionTreeNode functionTreeNode2 = SegmentationNode.getParentNode(functionTreeNode);
        if (functionTreeNode2 != null) {
            if (functionTreeNode2 instanceof SegmentationNode) {
                return ((SegmentationNode)functionTreeNode2).getDefaultPort();
            }
            return functionTreeNode2;
        }
        return null;
    }

    public static FunctionTreeNode getNodeOrDefaultPort(FunctionTreeNode functionTreeNode) {
        if (functionTreeNode instanceof SegmentationNode) {
            return ((SegmentationNode)functionTreeNode).getDefaultPort();
        }
        return functionTreeNode;
    }

    public static int getMaxLevel(FunctionTreeNode functionTreeNode, int n) {
        int n2 = n;
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            if (!functionTreeNode2.isEnabled()) continue;
            n2 = Math.max(SegmentationNode.getMaxLevel(functionTreeNode2, n), n2);
        }
        if (functionTreeNode instanceof SegmentationNode) {
            return n2 + 1;
        }
        return n2;
    }

    public static SegmentationNodeList getNodesAtLevel(FunctionTreeNode functionTreeNode, int n) {
        return SegmentationNode.getNodesAtLevel(functionTreeNode, n, true);
    }

    public static SegmentationNodeList getNodesAtLevel(FunctionTreeNode functionTreeNode, int n, boolean bl) {
        List<SegmentationNodeList> list = SegmentationNode.getSegmentationLists(functionTreeNode, bl);
        int n2 = n - 1;
        if (n2 >= 0 && n2 < list.size()) {
            return list.get(n2);
        }
        return new SegmentationNodeList(n);
    }

    public static List<SegmentationNodeList> getSegmentationLists(FunctionTreeNode functionTreeNode) {
        return SegmentationNode.getSegmentationLists(functionTreeNode, true);
    }

    public static List<SegmentationNodeList> getSegmentationLists(FunctionTreeNode functionTreeNode, boolean bl) {
        ArrayList<SegmentationNodeList> arrayList = new ArrayList<SegmentationNodeList>();
        SegmentationNode.addNodes(functionTreeNode, arrayList, 0, bl);
        return arrayList;
    }

    private static void addNodes(FunctionTreeNode functionTreeNode, List<SegmentationNodeList> list, int n, boolean bl) {
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            if (!(functionTreeNode2 instanceof SegmentationNode)) continue;
            SegmentationNode segmentationNode = (SegmentationNode)functionTreeNode2;
            if (bl && !functionTreeNode2.isEnabled()) continue;
            SegmentationNode.getSegList(list, n).add(segmentationNode);
            SegmentationNode.addNodes(segmentationNode.getDefaultPort(), list, n + 1, bl);
        }
    }

    private static SegmentationNodeList getSegList(List<SegmentationNodeList> list, int n) {
        if (n == list.size()) {
            list.add(new SegmentationNodeList(n + 1));
        }
        return list.get(n);
    }
}

