/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.analysistree;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.realtime.segmentation.spatial.ManualSegmentation;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailImage;

public class SegmentationNodeList
extends ArrayList<SegmentationNode> {
    private final int segmentationLevel;

    public SegmentationNodeList(int n) {
        this.segmentationLevel = n;
    }

    public int getSegmentationLevel() {
        return this.segmentationLevel;
    }

    @Override
    public SegmentationNode getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return (SegmentationNode)this.get(0);
    }

    public SegmentationNode getSegmentation(String string) {
        for (SegmentationNode segmentationNode : this) {
            if (!segmentationNode.getUid().equals(string)) continue;
            return segmentationNode;
        }
        return null;
    }

    public SegmentationNodeList filter(String string) {
        if (string != null) {
            SegmentationNodeList segmentationNodeList = new SegmentationNodeList(this.segmentationLevel);
            for (SegmentationNode segmentationNode : this) {
                if (!segmentationNode.getUid().equals(string)) continue;
                segmentationNodeList.add(segmentationNode);
            }
            return segmentationNodeList;
        }
        return this;
    }

    public List<SegmentationNode> getManualSegmentations() {
        ArrayList<SegmentationNode> arrayList = new ArrayList<SegmentationNode>();
        for (SegmentationNode segmentationNode : this) {
            if (!(segmentationNode.getFunction() instanceof ManualSegmentation)) continue;
            arrayList.add(segmentationNode);
        }
        return arrayList;
    }

    public List<DescriptorTreeNode> getNodes(Workflow workflow, boolean bl) {
        ArrayList<DescriptorTreeNode> arrayList = new ArrayList<DescriptorTreeNode>();
        for (SegmentationNode segmentationNode : this) {
            arrayList.addAll(segmentationNode.getDescriptorNodes(bl));
        }
        return arrayList;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (SegmentationNode segmentationNode : this) {
            String string = segmentationNode.getAliasOrNodeString();
            if (stringBuilder.length() > 0) {
                if (stringBuilder.toString().equals(string)) continue;
                stringBuilder.append("/");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static class SegmentationOverlap {
        private int p1;
        private int op1;

        public SegmentationOverlap(SegmentationSamples segmentationSamples, SegmentationSamples segmentationSamples2) {
            for (Map.Entry<Measurement, List<Sample>> entry : segmentationSamples.hashMap.entrySet()) {
                Measurement measurement = entry.getKey();
                List<Sample> list = entry.getValue();
                List<Sample> list2 = segmentationSamples2.hashMap.get(measurement);
                Rectangle rectangle = measurement.getBounds();
                BufferedImage bufferedImage = ThumbnailImage.createImageMask(measurement, list, rectangle, Collections.singletonList(segmentationSamples.getNode()));
                SampleModel sampleModel = bufferedImage.getSampleModel();
                DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
                if (list2 != null) {
                    BufferedImage bufferedImage2 = ThumbnailImage.createImageMask(measurement, list2, rectangle, Collections.singletonList(segmentationSamples2.getNode()));
                    SampleModel sampleModel2 = bufferedImage2.getSampleModel();
                    DataBuffer dataBuffer2 = bufferedImage2.getRaster().getDataBuffer();
                    for (int i = 0; i < rectangle.height; ++i) {
                        for (int j = 0; j < rectangle.width; ++j) {
                            if (sampleModel.getSample(j, i, 0, dataBuffer) == 0) continue;
                            ++this.p1;
                            if (sampleModel2.getSample(j, i, 0, dataBuffer2) == 0) continue;
                            ++this.op1;
                        }
                    }
                    continue;
                }
                for (int i = 0; i < rectangle.height; ++i) {
                    for (int j = 0; j < rectangle.width; ++j) {
                        if (sampleModel.getSample(j, i, 0, dataBuffer) == 0) continue;
                        ++this.p1;
                    }
                }
            }
        }

        public double percent() {
            if (this.p1 > 0) {
                return (double)this.op1 / (double)this.p1;
            }
            return 0.0;
        }
    }

    public static class SegmentationSamples {
        private final SegmentationNode node;
        private int number;
        private final HashMap<Measurement, List<Sample>> hashMap = new HashMap();
        private final List<SegmentationOverlap> overlaps = new ArrayList<SegmentationOverlap>();

        public SegmentationSamples(SegmentationNode segmentationNode, List list) {
            this.node = segmentationNode;
            for (Object e : list) {
                Sample sample = (Sample)e;
                if (!segmentationNode.getUid().equals(sample.getSegmentationHashId())) continue;
                Measurement measurement = sample.measurement();
                List<Sample> list2 = this.hashMap.get(measurement);
                if (list2 == null) {
                    list2 = new ArrayList<Sample>();
                    this.hashMap.put(measurement, list2);
                }
                list2.add(sample);
                ++this.number;
            }
        }

        public SegmentationNode getNode() {
            return this.node;
        }

        public int getNumber() {
            return this.number;
        }

        public void addOverlap(SegmentationSamples segmentationSamples) {
            this.overlaps.add(new SegmentationOverlap(this, segmentationSamples));
        }

        public List<SegmentationOverlap> getOverlaps() {
            return this.overlaps;
        }
    }
}

