/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.evaluatetree.impl;

import se.prediktera.breeze.common.entry.tree.evaluatetree.AbstractEvaluate;
import se.prediktera.breeze.common.entry.tree.evaluatetree.AbstractEvaluateInfo;
import se.prediktera.breeze.common.entry.tree.evaluatetree.impl.LogicalParameter;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;

public class LogicalEvaluate
extends AbstractEvaluate {
    private LogicalParameter logicalParameter = new LogicalParameter();

    public LogicalEvaluate(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(this.logicalParameter);
        this.addOutput("value");
    }

    @Override
    public double evaluate(FunctionTreeNode functionTreeNode, DescriptorInterface descriptorInterface) {
        boolean bl = this.logicalParameter.hasValue();
        LogicalParameter.Operator operator = this.logicalParameter.getOp();
        if (bl) {
            double d = this.logicalParameter.getValue();
            for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
                double d2 = functionTreeNode2.evaluate(descriptorInterface);
                if (operator.perform(d2, d)) continue;
                return 0.0;
            }
        } else {
            if (operator.isMulti()) {
                double d = 0.0;
                if (operator == LogicalParameter.Operator.AND) {
                    d = 1.0;
                }
                for (FunctionTreeNode functionTreeNode3 : functionTreeNode.getChildList()) {
                    double d3 = functionTreeNode3.evaluate(descriptorInterface);
                    switch (operator) {
                        case AND: {
                            if (d3 != 0.0) break;
                            return 0.0;
                        }
                        case OR: {
                            if (!(d3 > 0.0)) break;
                            return 1.0;
                        }
                    }
                }
                return d;
            }
            if (functionTreeNode.getChildCount() == 2) {
                double d;
                double d4 = functionTreeNode.getChild(0).evaluate(descriptorInterface);
                return operator.perform(d4, d = functionTreeNode.getChild(1).evaluate(descriptorInterface)) ? 1.0 : 0.0;
            }
        }
        return 1.0;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return this.logicalParameter.getNodeString();
    }

    @Override
    public boolean isComparison() {
        return true;
    }

    public static class Info
    extends AbstractEvaluateInfo {
        @Override
        public AbstractBreezeFunction createFunction() {
            return new LogicalEvaluate(this);
        }

        public String toString() {
            return "Logical";
        }
    }
}

