/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.evaluatetree.impl;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.Workflow;

public class LogicalParameter
extends NumberParameter {
    private Operator op = Operator.AND;

    public LogicalParameter() {
        super("operator", null, 0.0, null, null);
    }

    @Override
    public String getNodeString() {
        if (this.hasValue()) {
            return this.op.getName() + " " + RtDataFormat.toString(this.getValue());
        }
        return this.op.getName();
    }

    public Operator getOp() {
        return this.op;
    }

    @Override
    public void parse(Node node) {
        String string = XmlParserHelper.getAttribute(node, "type");
        this.op = Operator.valueOf(string.toUpperCase());
        this.clearValue();
        String string2 = node.getTextContent();
        if (string2 != null && string2.length() > 0) {
            this.setValue(Double.parseDouble(string2));
        }
    }

    @Override
    public void setValueStr(String string) {
        this.op = Operator.valueOf(string.toUpperCase());
        this.clearValue();
    }

    @Override
    public boolean setValue(Object object) {
        this.op = (Operator)((Object)object);
        return true;
    }

    @Override
    public Object getValueObj() {
        return this.op;
    }

    @Override
    public Element save(Element element) {
        Element element2 = super.save(element);
        XmlParserHelper.setAttribute((Node)element2, "type", this.op.name());
        return element2;
    }

    @Override
    public String toString() {
        if (this.hasValue()) {
            return this.op.toString() + ", value=" + RtDataFormat.toString(this.getValue());
        }
        return this.op.toString();
    }

    @Override
    public Object[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
        return Operator.values();
    }

    public static enum Operator {
        AND(true, "and"),
        OR(true, "or"),
        EQUALS(false, "="),
        NOTEQUALS(false, "!="),
        GREATER(false, ">"),
        GREATEREQUALS(false, "<"),
        LESS(false, "<"),
        LESSEQUALS(false, "<=");

        private final boolean multi;
        private final String name;

        private Operator(boolean bl, String string2) {
            this.multi = bl;
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public boolean isMulti() {
            return this.multi;
        }

        public boolean perform(double d, double d2) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (d == d2) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (d > 0.0 || d2 > 0.0) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (d == d2) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (d != d2) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (d > d2) {
                        yield true;
                    }
                    yield false;
                }
                case 5 -> {
                    if (d >= d2) {
                        yield true;
                    }
                    yield false;
                }
                case 6 -> {
                    if (d < d2) {
                        yield true;
                    }
                    yield false;
                }
                case 7 -> d <= d2;
            };
        }

        public String toString() {
            return super.toString() + " (" + this.name + ")";
        }
    }
}

