/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.evaluatetree.impl;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.Workflow;

public class MathParameter
extends NumberParameter {
    private Function op = Function.ADD;

    public MathParameter() {
        super("function", null, 0.0, null, null);
    }

    @Override
    public String getNodeString() {
        if (this.hasValue()) {
            return this.op.getName() + " " + this.getValue();
        }
        return this.op.getName();
    }

    public Function getOp() {
        return this.op;
    }

    @Override
    public void parse(Node node) {
        String string = XmlParserHelper.getAttribute(node, "type");
        this.op = Function.valueOf(string.toUpperCase());
        this.clearValue();
        String string2 = node.getTextContent();
        if (string2 != null && string2.length() > 0) {
            this.setValue(Double.parseDouble(string2));
        }
    }

    @Override
    public void setValueStr(String string) {
        this.op = Function.valueOf(string.toUpperCase());
        this.clearValue();
    }

    @Override
    public boolean setValue(Object object) {
        this.op = (Function)((Object)object);
        return true;
    }

    @Override
    public Object getValueObj() {
        return this.op;
    }

    @Override
    public Element save(Element element) {
        Element element2 = super.save(element);
        XmlParserHelper.setAttribute((Node)element2, "type", this.op.name());
        return element2;
    }

    @Override
    public String toString() {
        if (this.hasValue()) {
            return this.op.toString() + ", value=" + RtDataFormat.toString(this.getValue());
        }
        return this.op.toString();
    }

    @Override
    public Object[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
        return Function.values();
    }

    public static enum Function {
        ADD("+"),
        SUBTRACT("-"),
        MULT("*"),
        DIV("/");

        private final String name;

        private Function(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public double perform(double d, double d2) {
            switch (this.ordinal()) {
                case 2: {
                    return d * d2;
                }
                case 0: {
                    return d + d2;
                }
                case 3: {
                    return d / d2;
                }
                case 1: {
                    return d - d2;
                }
            }
            return 0.0;
        }

        public String toString() {
            return super.toString() + " (" + this.name + ")";
        }
    }
}

