/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.functiontree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractFunctionTree;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeList;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeListMap;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AnalyseFactorParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AnalyseParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.workflow.Workflow;

public abstract class AbstractBreezeFunction
implements AnalyseFactorParameter.AnalyseInterface {
    private final List<FunctionParameter> parameterList = new ArrayList<FunctionParameter>();
    private final List<String> outputList = new ArrayList<String>();
    private final AbstractBreezeFunctionInfo info;
    private FunctionTreeNodeWithId node;
    private Workflow workflowCache;

    public AbstractBreezeFunction(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        this.info = abstractBreezeFunctionInfo;
    }

    public void addOutput(String ... stringArray) {
        Collections.addAll(this.outputList, stringArray);
    }

    public void addParameter(FunctionParameter functionParameter) {
        this.addParameter(functionParameter, 0);
    }

    public void addParameter(FunctionParameter functionParameter, int n) {
        this.parameterList.add(this.getPriorityStart(n), functionParameter);
        functionParameter.setPriority(n);
    }

    private int getPriorityStart(int n) {
        for (int i = 0; i < this.parameterList.size(); ++i) {
            if (this.parameterList.get(i).getPriority() >= n) continue;
            return i;
        }
        return this.parameterList.size();
    }

    public FunctionTreeNode createNode() {
        FunctionTreeNode functionTreeNode = this.info.createNode();
        functionTreeNode.setFunction(this);
        return functionTreeNode;
    }

    public boolean equals(Object object) {
        return this.hashCode() == object.hashCode();
    }

    public int hashCode() {
        int n = this.info.getShortName().hashCode();
        for (FunctionParameter functionParameter : this.parameterList) {
            int n2 = functionParameter.getValueHashCode();
            if (n2 == 0) continue;
            n *= n2;
        }
        return n;
    }

    public short getIndexFromType(String string) {
        String[] stringArray = this.getOutputs();
        for (short s = 0; s < stringArray.length; s = (short)(s + 1)) {
            if (!stringArray[s].equalsIgnoreCase(string)) continue;
            return s;
        }
        return 0;
    }

    public AbstractBreezeFunctionInfo getInfo() {
        return this.info;
    }

    public String getName() {
        return this.getInfo().toString();
    }

    public Object getNameParam() {
        return this.toString();
    }

    public String getOutputName(int n) {
        String[] stringArray = this.getOutputs();
        if (stringArray != null && n >= 0 && n < stringArray.length) {
            return stringArray[n];
        }
        return this.info.getShortName();
    }

    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getOutputName(n));
        List<FunctionParameter> list = this.getParameterList();
        if (!list.isEmpty()) {
            stringBuilder.append("=");
        }
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i).getNodeString());
        }
        return stringBuilder.toString();
    }

    public List<String> getOutputList() {
        return this.outputList;
    }

    public String[] getOutputs() {
        return this.outputList.toArray(new String[0]);
    }

    public String getOutputString(int n) {
        if (n < this.outputList.size()) {
            return this.outputList.get(n);
        }
        return "NA";
    }

    public FunctionParameter getParameterByIndex(int n) {
        return this.parameterList.get(n);
    }

    public FunctionParameter getParameterByName(String string) {
        for (FunctionParameter functionParameter : this.parameterList) {
            if (!functionParameter.getName().equalsIgnoreCase(string) && !functionParameter.getBackwardCompatibilityName().equalsIgnoreCase(string)) continue;
            return functionParameter;
        }
        return null;
    }

    public List<FunctionParameter> getParameterList() {
        return this.parameterList;
    }

    public String getUnformattedValue(float f, int n, int n2) {
        return this.getStringValue(f, n, n2);
    }

    public String getStringValue(float f, int n, int n2) {
        return RtDataFormat.toString(f, n2, false);
    }

    public boolean isDescriptor() {
        return this.info.isDescriptor();
    }

    public void parse(Node node) {
        List<Node> list = XmlParserHelper.getNodeList(node, "param", null);
        if (list != null) {
            for (Node node2 : list) {
                String string = XmlParserHelper.getName(node2);
                FunctionParameter functionParameter = this.getParameterByName(string);
                if (functionParameter == null) continue;
                functionParameter.parse(node2);
            }
        }
    }

    public void save(Element element) {
        element.setAttribute("type", this.getName());
        for (FunctionParameter functionParameter : this.getParameterList()) {
            functionParameter.save(element);
        }
    }

    public boolean supportCache() {
        return false;
    }

    public void addToolTipText(Workflow workflow, FunctionTreeNode functionTreeNode, StringBuffer stringBuffer) {
        if (this.isDescriptor()) {
            stringBuffer.append("Descriptor = ");
        } else if (this.info.isSegmentation()) {
            stringBuffer.append("Segmentation = ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(this.getInfo().getDescription());
        }
        for (FunctionParameter functionParameter2 : this.parameterList.stream().filter(functionParameter -> !functionParameter.toString().isEmpty()).collect(Collectors.toList())) {
            Node node;
            BasicAnalyse basicAnalyse;
            if (!functionParameter2.isVisible(functionTreeNode)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("@");
            }
            stringBuffer.append(functionParameter2.format(workflow, functionTreeNode));
            if (!(functionParameter2 instanceof AnalyseParameter) || (basicAnalyse = ((AnalyseParameter)functionParameter2).getAnalyse()) == null) continue;
            BasicAnalyse.ModelMethod modelMethod = basicAnalyse.getModelMethod();
            stringBuffer.append("@Method = ");
            stringBuffer.append(modelMethod.getMethod());
            String string = basicAnalyse.getFormatedRating();
            if (string != null) {
                stringBuffer.append("@Rating = ");
                stringBuffer.append(string);
            }
            if (!(basicAnalyse instanceof Analyse) || !modelMethod.isRuntime() || (node = ((Analyse)basicAnalyse).getSetupXmlNode()) == null) continue;
            AbstractRuntimeModel.RuntimeResultList runtimeResultList = new AbstractRuntimeModel.RuntimeResultList(node);
            if (runtimeResultList.results.size() <= 0) continue;
            AbstractRuntimeModel.RuntimeResult runtimeResult = runtimeResultList.results.get(0);
            stringBuffer.append("@Algorithm = ");
            stringBuffer.append(runtimeResult.toString());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getInfo().toString());
        for (FunctionParameter functionParameter : this.parameterList) {
            stringBuilder.append("@");
            stringBuilder.append(functionParameter.toString());
        }
        return stringBuilder.toString();
    }

    public AbstractBreezeFunction clone() {
        AbstractBreezeFunction abstractBreezeFunction = this.info.createFunction();
        for (int i = 0; i < this.parameterList.size(); ++i) {
            abstractBreezeFunction.getParameterByIndex(i).copy(this.parameterList.get(i));
        }
        return abstractBreezeFunction;
    }

    public String getShapeType() {
        return "descriptor";
    }

    public boolean hasResult(int n) {
        return true;
    }

    public boolean hasThumbnail(int n) {
        return false;
    }

    public String getUnit(FunctionTreeNode functionTreeNode, int n) {
        return null;
    }

    public String getGroup() {
        AbstractCardInfo.GroupType groupType = this.getInfo().getGroup();
        if (groupType != null) {
            return groupType.name();
        }
        return null;
    }

    public MinMax getMinMax(int n) {
        return null;
    }

    public void setNode(FunctionTreeNodeWithId functionTreeNodeWithId) {
        this.node = functionTreeNodeWithId;
    }

    public FunctionTreeNodeWithId getNode() {
        return this.node;
    }

    public String getStudyId() {
        Workflow workflow = this.getWorkflow();
        if (workflow != null) {
            return workflow.getUid();
        }
        return null;
    }

    public String getStudyName() {
        Workflow workflow = this.getWorkflow();
        if (workflow != null) {
            return workflow.getName();
        }
        return "";
    }

    public Workflow getWorkflow() {
        if (this.workflowCache == null) {
            this.workflowCache = AbstractBreezeFunction.getWorkflowFromNode(this.node);
            return this.workflowCache;
        }
        return this.workflowCache;
    }

    public static Workflow getWorkflowFromNode(FunctionTreeNode functionTreeNode) {
        FunctionTreeListMap functionTreeListMap;
        FunctionTreeList functionTreeList;
        AbstractFunctionTree abstractFunctionTree;
        FunctionTreeNode functionTreeNode2;
        if (functionTreeNode != null && (functionTreeNode2 = functionTreeNode.getRoot()) != null && (abstractFunctionTree = functionTreeNode2.getTree()) != null && (functionTreeList = abstractFunctionTree.getParent()) != null && (functionTreeListMap = functionTreeList.getParent()) != null) {
            return functionTreeListMap.getWorkflow();
        }
        return null;
    }

    public List<ModelProperties.TransformationProperties> getTransformations() {
        return null;
    }

    public List<AdditionalFactor> getAdditionalFactors() {
        return null;
    }

    public boolean showOutputs() {
        return true;
    }

    public boolean isVisible(int n) {
        return true;
    }

    public String getAnalyseUid() {
        BasicAnalyse basicAnalyse = this.getAnalyse();
        if (basicAnalyse != null) {
            return basicAnalyse.getUid();
        }
        return null;
    }

    @Override
    public BasicAnalyse getAnalyse() {
        return null;
    }

    public Factor getFactor(int n) {
        return null;
    }

    public String getFactorUid(int n) {
        Factor factor = this.getFactor(n);
        if (factor != null) {
            return factor.getUid();
        }
        return null;
    }

    public Factor getVisualizationFactor(int n) {
        return this.getFactor(n);
    }

    public boolean showInTable() {
        return true;
    }

    public void preRequisiteRuntimeExport(BreezeProgress breezeProgress) {
    }

    public boolean changeHierarchical(FunctionParameter functionParameter) {
        return true;
    }

    public static class MethodException
    extends RuntimeException {
        public MethodException(AbstractBreezeFunction abstractBreezeFunction, String string) {
            super("\n\n" + abstractBreezeFunction.getInfo().getDescription() + "\n\nCause: " + string);
        }
    }
}

