/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.functiontree;

import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.evaluatetree.EvaluateNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.map.common.BrowserLauncher;
import se.prediktera.map.register.RegInfo;

public abstract class AbstractBreezeFunctionInfo
implements AbstractCardInfo {
    public abstract AbstractBreezeFunction createFunction();

    public abstract FunctionType getType();

    public final boolean isDescriptor() {
        return this.getType().equals((Object)FunctionType.Descriptor);
    }

    public final boolean isSegmentation() {
        return this.getType().equals((Object)FunctionType.Segmentation);
    }

    public boolean isVisibleInList() {
        return true;
    }

    public boolean validLicense() {
        RegInfo.LicenseFeature licenseFeature = this.getLicenseFeature();
        if (licenseFeature != null) {
            return switch (licenseFeature) {
                default -> throw new MatchException(null, null);
                case RegInfo.LicenseFeature.Application -> RegInfo.isApplicationFeature();
                case RegInfo.LicenseFeature.Geo -> RegInfo.isGeoFeature();
                case RegInfo.LicenseFeature.CoreScanner -> RegInfo.isFeatureActiveStatic((RegInfo.LicenseFeature)RegInfo.LicenseFeature.CoreScanner);
                case RegInfo.LicenseFeature.Record -> {
                    if (RegInfo.isApplicationFeature() || RegInfo.isRecordFeature()) {
                        yield true;
                    }
                    yield false;
                }
                case RegInfo.LicenseFeature.HySpexRecorder -> RegInfo.isFeatureActiveStatic((RegInfo.LicenseFeature)RegInfo.LicenseFeature.HySpexRecorder);
                case RegInfo.LicenseFeature.Industrial -> RegInfo.isFeatureActiveStatic((RegInfo.LicenseFeature)RegInfo.LicenseFeature.Industrial);
            };
        }
        return true;
    }

    public RegInfo.LicenseFeature getLicenseFeature() {
        return RegInfo.LicenseFeature.Application;
    }

    public final int getRank() {
        AbstractCardInfo.GroupType groupType = this.getGroup();
        if (groupType != null) {
            return groupType.ordinal();
        }
        return 1000;
    }

    public FunctionTreeNode createNode() {
        return new EvaluateNode();
    }

    @Override
    public AbstractCardInfo.GroupType getGroup() {
        return null;
    }

    public boolean support(BreezeType breezeType) {
        return true;
    }

    public static void showHelpOnline(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        if (abstractBreezeFunctionInfo != null && abstractBreezeFunctionInfo.getHelp() != null) {
            BrowserLauncher.open((String)("https://help.prediktera.com/breeze/" + abstractBreezeFunctionInfo.getHelp()));
        } else {
            BrowserLauncher.open((String)"https://help.prediktera.com/breeze");
        }
    }

    public static enum FunctionType {
        All,
        Segmentation,
        Descriptor,
        Action,
        Evaluate;


        public static FunctionType parse(String string) {
            for (FunctionType functionType : FunctionType.values()) {
                if (!functionType.name().equalsIgnoreCase(string)) continue;
                return functionType;
            }
            return All;
        }
    }

    public static enum FunctionApplied {
        All,
        Record,
        Play;

    }
}

