/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.functiontree;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluateResultHolder;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeList;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.image.RtSpatialObject;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;

public abstract class AbstractFunctionTree
implements Serializable,
Cloneable {
    private String name;
    private FunctionTreeList parent;

    public AbstractFunctionTree() {
    }

    public AbstractFunctionTree(String string) {
        this();
        this.name = string;
    }

    public void calculateDescriptors(BreezeProgress breezeProgress, DescriptorInterface descriptorInterface, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject) {
        HashMap<AbstractBreezeFunction, float[]> hashMap = new HashMap<AbstractBreezeFunction, float[]>();
        this.calculateDescriptors(breezeProgress, descriptorInterface, hashMap, rtFramesAndRefs, rtSpatialObject);
    }

    public abstract void calculateDescriptors(BreezeProgress var1, DescriptorInterface var2, HashMap<AbstractBreezeFunction, float[]> var3, RtFramesAndRefs var4, RtSpatialObject var5);

    public abstract double evaluate(DescriptorInterface var1);

    public EvaluateResultHolder evaluateAll(DescriptorInterface descriptorInterface) {
        return null;
    }

    public abstract List<DescriptorTreeNode> getDescriptorNodes();

    public String getName() {
        return this.name;
    }

    public FunctionTreeNode getRoot() {
        return null;
    }

    public abstract void removeDescriptorNodes(List<DescriptorTreeNode> var1);

    public Node save(Node node, boolean bl) {
        Element element = XmlParserHelper.addElement(node, "graph");
        XmlParserHelper.setAttribute((Node)element, "type", this.getType());
        String string = this.getName();
        if (string != null && string.length() > 0) {
            XmlParserHelper.setAttribute((Node)element, "name", this.getName());
        }
        return element;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    protected abstract String getType();

    public void setParent(FunctionTreeList functionTreeList) {
        this.parent = functionTreeList;
    }

    public FunctionTreeList getParent() {
        return this.parent;
    }
}

