/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.functiontree;

import java.util.List;
import lombok.Generated;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluateResultHolder;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;

public class EvaluateResult {
    private FunctionTreeNode node;
    private Double result;
    private String description;
    private String messageId = null;
    private EvaluateResultHolder holder;
    private static final String[][] MWARRAY = new String[][]{{"WM0001", "White reference exceeds 95% of max signal, possible saturation"}, {"WM0002", "White reference is lower than 50% of max signal"}, {"WM0003", "Number of dropped frames exceeds 20%"}, {"WM0004", "Uneven white reference, possible defect lamp"}, {"WM0101", "Measurement has been changed, apply changes"}};

    public EvaluateResult(FunctionTreeNode functionTreeNode, Double d) {
        this.node = functionTreeNode;
        this.result = d;
    }

    public EvaluateResult(String string, String string2) {
        this(string);
        this.description = string2;
    }

    public EvaluateResult(String string) {
        this.messageId = string;
    }

    public String getMessageDescription() {
        String string = this.getMessageId();
        if (string != null && string.startsWith("WM")) {
            for (String[] stringArray : MWARRAY) {
                if (!stringArray[0].equals(string)) continue;
                return stringArray[1];
            }
        }
        return this.getDescription();
    }

    public String getMessageId() {
        if (this.messageId != null) {
            return this.messageId;
        }
        return this.node.getAlias();
    }

    public boolean hasFail() {
        if (this.messageId != null) {
            return true;
        }
        if (this.node.isComparison()) {
            return this.result.doubleValue() == this.holder.getFailurevalue();
        }
        return false;
    }

    public String toString() {
        if (this.node != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.node);
            stringBuilder.append(" = ");
            stringBuilder.append(this.result);
            return stringBuilder.toString();
        }
        return null;
    }

    public static EvaluateResult getWarningById(List<EvaluateResult> list, String string) {
        if (list != null && !list.isEmpty()) {
            for (EvaluateResult evaluateResult : list) {
                if (!evaluateResult.getMessageId().equals(string)) continue;
                return evaluateResult;
            }
        }
        return null;
    }

    @Generated
    public FunctionTreeNode getNode() {
        return this.node;
    }

    @Generated
    public Double getResult() {
        return this.result;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String string) {
        this.description = string;
    }

    @Generated
    public void setMessageId(String string) {
        this.messageId = string;
    }

    @Generated
    public EvaluateResultHolder getHolder() {
        return this.holder;
    }

    @Generated
    public void setHolder(EvaluateResultHolder evaluateResultHolder) {
        this.holder = evaluateResultHolder;
    }
}

