/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.functiontree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractFunctionTree;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluateResultHolder;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.entry.tree.functiontree.TreeListInterface;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.ObjectHolder;
import se.prediktera.breeze.common.util.image.RtSpatialObject;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.map.common.error.Logg;

public class EvaluationTree
extends AbstractFunctionTree
implements TreeListInterface {
    private FunctionTreeNode root;

    public EvaluationTree(FunctionTreeNode functionTreeNode) {
        this();
        this.setRoot(functionTreeNode);
    }

    public EvaluationTree() {
        super("workflow");
    }

    public EvaluationTree(Node node, HashMap<String, AbstractBreezeFunction> hashMap) {
        this.setName(XmlParserHelper.getName(node));
        List<Node> list = XmlParserHelper.getNodeList(node, "function", null);
        if (list.size() > 0) {
            Node node2 = list.get(0);
            FunctionTreeNode functionTreeNode = this.parseDefaultFunction(node2, hashMap);
            this.parseTree(functionTreeNode, node2, hashMap);
            this.setRoot(functionTreeNode);
        }
    }

    private void parseTree(FunctionTreeNode functionTreeNode, Node node, HashMap<String, AbstractBreezeFunction> hashMap) {
        List<Node> list = XmlParserHelper.getNodeList(node, "function", null);
        for (Node node2 : list) {
            FunctionTreeNode functionTreeNode2 = this.parseDefaultFunction(node2, hashMap);
            if (functionTreeNode != null && functionTreeNode2 != null) {
                functionTreeNode.addChild(functionTreeNode2);
            }
            this.parseTree(functionTreeNode2, node2, hashMap);
        }
    }

    private FunctionTreeNode parseDefaultFunction(Node node, HashMap<String, AbstractBreezeFunction> hashMap) {
        String string = XmlParserHelper.getAttribute(node, "type");
        FunctionTreeNode functionTreeNode = FunctionHelper.createDefaultFunction(string);
        if (functionTreeNode == null) {
            return null;
        }
        functionTreeNode.parse(node);
        AbstractBreezeFunction abstractBreezeFunction = functionTreeNode.getFunction();
        if (abstractBreezeFunction != null && abstractBreezeFunction.supportCache()) {
            AbstractBreezeFunction abstractBreezeFunction2 = hashMap.get(abstractBreezeFunction.toString());
            if (abstractBreezeFunction2 == null) {
                abstractBreezeFunction2 = abstractBreezeFunction;
                hashMap.put(abstractBreezeFunction.toString(), abstractBreezeFunction2);
            }
            functionTreeNode.setFunction(abstractBreezeFunction2);
        }
        return functionTreeNode;
    }

    @Override
    public void calculateDescriptors(BreezeProgress breezeProgress, DescriptorInterface descriptorInterface, HashMap<AbstractBreezeFunction, float[]> hashMap, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject) {
        FunctionTreeNode functionTreeNode = this.getRoot();
        if (functionTreeNode != null) {
            functionTreeNode.calculateDescriptors(breezeProgress, hashMap, descriptorInterface, rtFramesAndRefs, rtSpatialObject);
        }
    }

    @Override
    public double evaluate(DescriptorInterface descriptorInterface) {
        FunctionTreeNode functionTreeNode = this.getRoot();
        if (functionTreeNode != null) {
            return functionTreeNode.evaluate(descriptorInterface);
        }
        return 0.0;
    }

    @Override
    public EvaluateResultHolder evaluateAll(DescriptorInterface descriptorInterface) {
        FunctionTreeNode functionTreeNode = this.getRoot();
        if (functionTreeNode != null) {
            double d = 0.0;
            if (this.getName().equals("Warning")) {
                d = 1.0;
            }
            EvaluateResultHolder evaluateResultHolder = new EvaluateResultHolder(this, d);
            functionTreeNode.evaluateAll(evaluateResultHolder, descriptorInterface);
            return evaluateResultHolder;
        }
        return null;
    }

    @Override
    public List<DescriptorTreeNode> getDescriptorNodes() {
        ArrayList<DescriptorTreeNode> arrayList = new ArrayList<DescriptorTreeNode>();
        if (this.getRoot() != null) {
            this.getDescriptorNodes(arrayList);
        }
        return arrayList;
    }

    public void getDescriptorNodes(List<DescriptorTreeNode> list) {
        this.getRoot().getDescriptors(list);
    }

    public AbstractBreezeFunction getFunction() {
        FunctionTreeNode functionTreeNode = this.getRoot();
        if (functionTreeNode != null) {
            return functionTreeNode.getFunction();
        }
        return null;
    }

    @Override
    public FunctionTreeNode getRoot() {
        return this.root;
    }

    @Override
    public String getType() {
        return "evaluation";
    }

    @Override
    public void removeDescriptorNodes(List<DescriptorTreeNode> list) {
        this.getRoot().removeDescriptors(list);
    }

    @Override
    public Node save(Node node, boolean bl) {
        Node node2 = super.save(node, bl);
        FunctionTreeNode functionTreeNode = this.getRoot();
        if (functionTreeNode != null) {
            node = this.saveTree(node2, functionTreeNode, bl);
        }
        return null;
    }

    public void setRoot(FunctionTreeNode functionTreeNode) {
        this.root = functionTreeNode;
        functionTreeNode.setTree(this);
    }

    private Node saveTree(Node node, FunctionTreeNode functionTreeNode, boolean bl) {
        node = functionTreeNode.save(node);
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            if (!bl && !functionTreeNode2.isEnabled()) continue;
            this.saveTree(node, functionTreeNode2, bl);
        }
        return node;
    }

    @Override
    public FunctionTreeNodeWithId getTreeNodeById(String string) {
        return this.getRoot().getNodeById(string);
    }

    public void loadRtAnalyis() {
        try {
            this.loadRtAnalysis(this.root);
        }
        catch (Exception exception) {
            Logg.error((String)"Cannot load analysis", (Throwable)exception);
        }
    }

    private void loadRtAnalysis(FunctionTreeNode functionTreeNode) {
        functionTreeNode.getAnalyse();
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            this.loadRtAnalysis(functionTreeNode2);
        }
    }

    public void forEveryFunction(FunctionAction functionAction) {
        this.forEveryNode(this.getRoot(), functionTreeNode -> {
            AbstractBreezeFunction abstractBreezeFunction = functionTreeNode.getFunction();
            if (abstractBreezeFunction != null) {
                functionAction.onFunction(functionTreeNode, abstractBreezeFunction);
            }
        });
    }

    public void forEveryNode(NodeAction nodeAction) {
        this.forEveryNode(this.getRoot(), nodeAction);
    }

    private void forEveryNode(FunctionTreeNode functionTreeNode, NodeAction nodeAction) {
        nodeAction.onNode(functionTreeNode);
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            this.forEveryNode(functionTreeNode2, nodeAction);
        }
    }

    public FunctionTreeNode getNodeByUid(String string) {
        ObjectHolder objectHolder = new ObjectHolder();
        this.forEveryFunction((functionTreeNode, abstractBreezeFunction) -> {
            FunctionTreeNodeWithId functionTreeNodeWithId;
            if (functionTreeNode instanceof FunctionTreeNodeWithId && (functionTreeNodeWithId = (FunctionTreeNodeWithId)functionTreeNode).getUid().equals(string)) {
                objectHolder.set(functionTreeNode);
            }
        });
        return (FunctionTreeNode)objectHolder.getValue();
    }

    public List<FunctionTreeNode> getSegmentationNodes(SegmentationIdentifier segmentationIdentifier) {
        if (segmentationIdentifier.HashId != null) {
            return List.of(this.getNodeByUid(segmentationIdentifier.HashId));
        }
        return new ArrayList<FunctionTreeNode>(SegmentationNode.getNodesAtLevel(this.getRoot(), segmentationIdentifier.Level, false));
    }

    public static interface FunctionAction {
        public void onFunction(FunctionTreeNode var1, AbstractBreezeFunction var2);
    }

    public static interface NodeAction {
        public void onNode(FunctionTreeNode var1);
    }
}

