/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.functiontree;

import java.awt.Color;
import java.io.Serializable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.entry.workflow.PropertyLimit;

public class FunctionResult
implements Cloneable,
Serializable {
    public float value;
    private DescriptorTreeNode node;
    private boolean missing = true;

    public FunctionResult(float f) {
        this.value = f;
    }

    public FunctionResult(DescriptorTreeNode descriptorTreeNode, float f) {
        this.node = descriptorTreeNode;
        this.value = f;
    }

    public FunctionResult(DescriptorTreeNode descriptorTreeNode) {
        this.node = descriptorTreeNode;
    }

    public FunctionResult(DescriptorTreeNode descriptorTreeNode, Node node) {
        this(descriptorTreeNode);
        if (!XmlParserHelper.isFloatMissing(node)) {
            float f = XmlParserHelper.getFloatValue(node);
            this.setValue(f);
        }
    }

    public BasicAnalyse getAnalyse() {
        return this.node.getAnalyse();
    }

    public Factor getFactor() {
        return this.node.getFactor();
    }

    public Factor getVisualizationFactor() {
        return this.node.getVisualizationFactor();
    }

    public AbstractBreezeFunction getFunction() {
        return this.node.getFunction();
    }

    public String getStringValueWithUnit() {
        String string = this.getStringValue(5);
        String string2 = this.node.getUnit();
        if (string2 != null) {
            return string + " " + string2;
        }
        return string;
    }

    public String getUnformattedValue(int n) {
        return this.node.getFunction().getUnformattedValue(this.getValue(), this.node.getIndex(), n);
    }

    public String getStringValue(int n) {
        return this.node.getFunction().getStringValue(this.getValue(), this.node.getIndex(), n);
    }

    public MinMax getMinMax(LimitConfiguration limitConfiguration) {
        Factor factor = this.node.getVisualizationFactor();
        if (limitConfiguration != null && factor != null) {
            PropertyLimit propertyLimit = limitConfiguration.getWrapper(factor);
            if (propertyLimit != null) {
                return propertyLimit.getMinMax();
            }
        } else if (factor != null && factor.getMinMax() != null) {
            return factor.getMinMax();
        }
        return this.getMinMax();
    }

    public MinMax getMinMax() {
        return this.node.getFunction().getMinMax(this.node.getIndex());
    }

    public float getValue() {
        return this.value;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public void setValue(float f) {
        this.value = f;
        this.missing = false;
    }

    public String toString() {
        return String.valueOf(this.getValue());
    }

    public DescriptorTreeNode getNode() {
        return this.node;
    }

    public void writeXmlNode(Node node) {
        Element element = XmlParserHelper.addElement(node, "value");
        element.setAttribute("id", this.node.getUid());
        if (!this.isMissing()) {
            element.setTextContent(String.valueOf(this.getValue()));
        }
    }

    public boolean equalTo(DescriptorTreeNode descriptorTreeNode) {
        return this.node.getUid().equals(descriptorTreeNode.getUid());
    }

    public void setValue(BasicSample basicSample, boolean bl, boolean bl2) {
        this.getAnalyse().sampleIncluded(basicSample, bl, bl2);
    }

    public void setPredictionValueToFactor(BasicSample basicSample) {
        basicSample.getSampleValues().setValue(this.getFactor(), this.getValue());
        for (BasicSample basicSample2 : basicSample.getChildList()) {
            this.setPredictionValueToFactor(basicSample2);
        }
    }

    public static String getCategoryColorHexString(FunctionResult functionResult) {
        Factor factor;
        if (functionResult != null && (factor = functionResult.getFactor()) instanceof CategoryFactor) {
            return RtPerfectSpread.getColorToString(((CategoryFactor)factor).getClassByValueIdx((int)functionResult.getValue()).getColor());
        }
        return RtPerfectSpread.getColorToString(Color.red);
    }

    public int getIndex() {
        return this.node.getIndex();
    }

    public float getNormalisedFloatValue(MinMax minMax) {
        return minMax.normalise(this.value).floatValue();
    }
}

