/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.functiontree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractFunctionTree;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluationTree;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeListMap;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.entry.tree.functiontree.TreeListInterface;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;

public class FunctionTreeList
implements Iterable<AbstractFunctionTree>,
Cloneable,
TreeListInterface {
    private String name;
    private final FunctionTreeListMap parent;
    private final List<AbstractFunctionTree> functionGraphList = new ArrayList<AbstractFunctionTree>();

    public FunctionTreeList(FunctionTreeListMap functionTreeListMap) {
        this.parent = functionTreeListMap;
    }

    public void addChild(AbstractFunctionTree abstractFunctionTree) {
        abstractFunctionTree.setParent(this);
        this.functionGraphList.add(abstractFunctionTree);
    }

    public AbstractFunctionTree getDefaultFunctionTree() {
        Iterator<AbstractFunctionTree> iterator = this.iterator();
        if (iterator.hasNext()) {
            AbstractFunctionTree abstractFunctionTree = iterator.next();
            return abstractFunctionTree;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void parse(FunctionTreeListMap functionTreeListMap, Node node, HashMap<String, AbstractBreezeFunction> hashMap) {
        List<Node> list = XmlParserHelper.getNodeList(node, "graph", null);
        for (Node node2 : list) {
            String string = XmlParserHelper.getAttribute(node2, "type");
            this.addChild(this.createChild(string, node2, hashMap));
        }
    }

    private AbstractFunctionTree createChild(String string, Node node, HashMap<String, AbstractBreezeFunction> hashMap) {
        return new EvaluationTree(node, hashMap);
    }

    public void perform(BreezeProgress breezeProgress, DescriptorInterface descriptorInterface, RtFramesAndRefs rtFramesAndRefs) {
        for (AbstractFunctionTree abstractFunctionTree : this) {
            EvaluationTree evaluationTree = (EvaluationTree)abstractFunctionTree;
            evaluationTree.calculateDescriptors(breezeProgress, descriptorInterface, rtFramesAndRefs, null);
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public AbstractFunctionTree getGraphByName(String string) {
        for (AbstractFunctionTree abstractFunctionTree : this) {
            if (!abstractFunctionTree.getName().equals(string)) continue;
            return abstractFunctionTree;
        }
        return null;
    }

    @Override
    public Iterator<AbstractFunctionTree> iterator() {
        return this.functionGraphList.iterator();
    }

    public List<AbstractFunctionTree> getChildList() {
        return this.functionGraphList;
    }

    @Override
    public FunctionTreeNodeWithId getTreeNodeById(String string) {
        for (AbstractFunctionTree abstractFunctionTree : this.getChildList()) {
            FunctionTreeNodeWithId functionTreeNodeWithId = ((EvaluationTree)abstractFunctionTree).getTreeNodeById(string);
            if (functionTreeNodeWithId == null) continue;
            return functionTreeNodeWithId;
        }
        return null;
    }

    public FunctionTreeListMap getParent() {
        return this.parent;
    }
}

