/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.functiontree;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractFunctionTree;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluationTree;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeList;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.Workflow;

public class FunctionTreeListMap {
    private final HashMap<String, FunctionTreeList> functionTreeListHash;
    private final Workflow workflow;

    public FunctionTreeListMap(Workflow workflow) {
        this.workflow = workflow;
        this.functionTreeListHash = new HashMap();
    }

    public void addRecipes(Element element, FunctionTreeList functionTreeList) {
        List<AbstractFunctionTree> list = functionTreeList.getChildList();
        Element element2 = XmlParserHelper.addElement(element, "context");
        element2.setAttribute("name", functionTreeList.getName());
        for (AbstractFunctionTree abstractFunctionTree : list) {
            abstractFunctionTree.save(element2, true);
        }
    }

    public List<FunctionTreeList> getFunctionGraphs() {
        ArrayList<FunctionTreeList> arrayList = new ArrayList<FunctionTreeList>();
        Set<Map.Entry<String, FunctionTreeList>> set = this.functionTreeListHash.entrySet();
        for (Map.Entry<String, FunctionTreeList> entry : set) {
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public AbstractFunctionTree getFunctionTree(String string, String string2) {
        FunctionTreeList functionTreeList = this.getFunctionTreeList(string);
        if (functionTreeList != null) {
            for (AbstractFunctionTree abstractFunctionTree : functionTreeList.getChildList()) {
                if (!abstractFunctionTree.getName().equalsIgnoreCase(string2)) continue;
                return abstractFunctionTree;
            }
        }
        return null;
    }

    public FunctionTreeList getFunctionTreeList(String string) {
        FunctionTreeList functionTreeList = this.functionTreeListHash.get(string);
        if (functionTreeList == null) {
            functionTreeList = new FunctionTreeList(this);
            functionTreeList.setName(string);
            this.functionTreeListHash.put(string, functionTreeList);
        }
        return functionTreeList;
    }

    public void parse(Node node) {
        HashMap<String, AbstractBreezeFunction> hashMap = new HashMap<String, AbstractBreezeFunction>();
        List<Node> list = XmlParserHelper.getNodeList(node, "context", null);
        for (Node node2 : list) {
            this.parse(hashMap, node2);
        }
    }

    public void parse(HashMap<String, AbstractBreezeFunction> hashMap, Node node) {
        String string = XmlParserHelper.getName(node);
        FunctionTreeList functionTreeList = this.createFunctionGraph();
        functionTreeList.setName(string);
        functionTreeList.parse(this, node, hashMap);
        this.functionTreeListHash.put(string, functionTreeList);
    }

    public void clear() {
        this.functionTreeListHash.clear();
    }

    public Element save(Node node) {
        Element element = XmlParserHelper.addElement(node, "descriptors");
        for (FunctionTreeList functionTreeList : this.functionTreeListHash.values()) {
            this.addRecipes(element, functionTreeList);
        }
        return element;
    }

    public void addWorkflowTree(EvaluationTree evaluationTree) {
        FunctionTreeList functionTreeList = this.createFunctionGraph();
        functionTreeList.setName("workflow");
        functionTreeList.addChild(evaluationTree);
        this.functionTreeListHash.put("workflow", functionTreeList);
    }

    protected FunctionTreeList createFunctionGraph() {
        return new FunctionTreeList(this);
    }

    public void parse(InputStream inputStream) {
        NodeList nodeList = XmlParserHelper.parseXML(inputStream);
        this.parseChildren(nodeList);
    }

    private void parseChildren(NodeList nodeList) {
        NodeList nodeList2 = nodeList.item(0).getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            this.parse(nodeList2.item(i));
        }
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }
}

