/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.entry.tree.functiontree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.ObjectWithChildrenAndParent;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.evaluatetree.impl.NoneEvaluate;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractFunctionTree;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluateResult;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluateResultHolder;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.entry.util.BasicTreeParentInterface;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.image.RtSpatialObject;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.Workflow;

public abstract class FunctionTreeNode
implements ObjectWithChildrenAndParent<FunctionTreeNode, FunctionTreeNode>,
Cloneable,
BasicTreeParentInterface {
    private String alias = null;
    private FunctionTreeNode parent;
    private List<FunctionTreeNode> childList = new ArrayList<FunctionTreeNode>();
    private boolean enabled = true;
    private AbstractFunctionTree tree;
    private final long created = System.currentTimeMillis();
    private Float legendMax;
    private Float legendMin;

    public boolean isComparison() {
        return false;
    }

    public void calculateDescriptors(BreezeProgress breezeProgress, HashMap<AbstractBreezeFunction, float[]> hashMap, DescriptorInterface descriptorInterface, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject) {
        for (FunctionTreeNode functionTreeNode : this.getChildList()) {
            functionTreeNode.calculateDescriptors(breezeProgress, hashMap, descriptorInterface, rtFramesAndRefs, rtSpatialObject);
        }
    }

    public FunctionTreeNode clone(boolean bl) {
        try {
            FunctionTreeNode functionTreeNode = (FunctionTreeNode)super.clone();
            functionTreeNode.setChildList(new ArrayList<FunctionTreeNode>());
            for (FunctionTreeNode functionTreeNode2 : this.getChildList()) {
                functionTreeNode.addChild(functionTreeNode2.clone(bl));
            }
            return functionTreeNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public abstract double evaluate(DescriptorInterface var1);

    public void evaluateAll(EvaluateResultHolder evaluateResultHolder, DescriptorInterface descriptorInterface) {
        for (FunctionTreeNode functionTreeNode : this.getChildList()) {
            functionTreeNode.evaluateAll(evaluateResultHolder, descriptorInterface);
        }
        EvaluateResult evaluateResult = new EvaluateResult(this, this.evaluate(descriptorInterface));
        evaluateResultHolder.put(this, evaluateResult);
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAliasOrSimpleNodeString() {
        return this.getAliasOrNodeString(TextType.Simple);
    }

    public String getAliasOrNodeString() {
        return this.getAliasOrNodeString(TextType.Normal);
    }

    public String getAliasOrNodeString(TextType textType) {
        if (this.alias != null) {
            return this.alias;
        }
        return this.getNodeString(textType);
    }

    public void getDescriptors(List<DescriptorTreeNode> list) {
        for (FunctionTreeNode functionTreeNode : this.getChildList()) {
            functionTreeNode.getDescriptors(list);
        }
    }

    public abstract AbstractBreezeFunction getFunction();

    public final FunctionTreeNodeWithId getNodeById(String string) {
        if (string != null) {
            Object object;
            FunctionTreeNode functionTreeNode2 = this;
            if (functionTreeNode2 instanceof FunctionTreeNodeWithId && string.equals(((FunctionTreeNodeWithId)(object = (FunctionTreeNodeWithId)functionTreeNode2)).getUid())) {
                return object;
            }
            for (FunctionTreeNode functionTreeNode2 : this.getChildList()) {
                FunctionTreeNodeWithId functionTreeNodeWithId = functionTreeNode2.getNodeById(string);
                if (functionTreeNodeWithId == null) continue;
                return functionTreeNodeWithId;
            }
        }
        return null;
    }

    public final FunctionTreeNode getNodeByInfo(AbstractDescriptorInfo abstractDescriptorInfo) {
        for (FunctionTreeNode functionTreeNode : this.getChildList()) {
            if (!functionTreeNode.getFunction().getInfo().toString().equals(abstractDescriptorInfo.toString())) continue;
            return functionTreeNode;
        }
        return null;
    }

    public String getNodeString(TextType textType) {
        return this.toString();
    }

    public String getShapeType() {
        return "evaluate";
    }

    public void parse(Node node) {
        this.alias = XmlParserHelper.getAttribute(node, "alias");
        this.enabled = XmlParserHelper.getBooleanAttribute(node, "enabled", true);
        this.setLegendMax(XmlParserHelper.getFloatObjectAttribute(node, "legendMax"));
        this.setLegendMin(XmlParserHelper.getFloatObjectAttribute(node, "legendMin"));
    }

    public void removeDescriptors(List<DescriptorTreeNode> list) {
        this.getChildList().removeAll(list);
        for (FunctionTreeNode functionTreeNode : this.getChildList()) {
            functionTreeNode.removeDescriptors(list);
        }
    }

    public Node save(Node node) {
        Element element = XmlParserHelper.addElement(node, this.getNodeType());
        if (this.alias != null) {
            element.setAttribute("alias", this.alias);
        }
        if (!this.enabled) {
            element.setAttribute("enabled", "false");
        }
        if (this.getLegendMax() != null) {
            element.setAttribute("legendMax", RtDataFormat.toString(this.getLegendMax().floatValue()));
        }
        if (this.getLegendMin() != null) {
            element.setAttribute("legendMin", RtDataFormat.toString(this.getLegendMin().floatValue()));
        }
        return element;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setFunction(AbstractBreezeFunction abstractBreezeFunction) {
    }

    public void replaceWith(FunctionTreeNode functionTreeNode) {
        this.replaceChild(this.getParent(), this, functionTreeNode);
        for (FunctionTreeNode functionTreeNode2 : this.getChildList()) {
            functionTreeNode.addChild(functionTreeNode2);
        }
    }

    private void replaceChild(FunctionTreeNode functionTreeNode, FunctionTreeNode functionTreeNode2, FunctionTreeNode functionTreeNode3) {
        List<FunctionTreeNode> list = functionTreeNode.getChildList();
        int n = list.indexOf(functionTreeNode2);
        if (n >= 0) {
            list.set(n, functionTreeNode3);
            functionTreeNode3.setParent(functionTreeNode2.getParent());
        }
    }

    protected String getNodeType() {
        return "function";
    }

    public boolean isManualAdd() {
        return true;
    }

    public boolean isDuplicate() {
        return !(this.getFunction() instanceof NoneEvaluate);
    }

    public List<DescriptorTreeNode> getDescriptorNodes(boolean bl) {
        ArrayList<DescriptorTreeNode> arrayList = new ArrayList<DescriptorTreeNode>();
        for (FunctionTreeNode functionTreeNode : this.getChildList()) {
            if (!(functionTreeNode instanceof DescriptorTreeNode)) continue;
            arrayList.add((DescriptorTreeNode)functionTreeNode);
            if (!bl) continue;
            arrayList.addAll(functionTreeNode.getDescriptorNodes(bl));
        }
        return arrayList;
    }

    public List<DescriptorTreeNode> getAllDescriptorNodes() {
        ArrayList<DescriptorTreeNode> arrayList = new ArrayList<DescriptorTreeNode>();
        for (FunctionTreeNode functionTreeNode : this.getChildList()) {
            if (functionTreeNode instanceof DescriptorTreeNode) {
                arrayList.add((DescriptorTreeNode)functionTreeNode);
            }
            arrayList.addAll(functionTreeNode.getAllDescriptorNodes());
        }
        return arrayList;
    }

    @Override
    public List<FunctionTreeNode> getChildren() {
        return this.getChildList();
    }

    public void setParent(FunctionTreeNode functionTreeNode) {
        this.parent = functionTreeNode;
    }

    @Override
    public FunctionTreeNode getParent() {
        return this.parent;
    }

    public void setChildList(List<FunctionTreeNode> list) {
        this.childList = list;
    }

    public List<FunctionTreeNode> getChildList() {
        return this.childList;
    }

    @Override
    public FunctionTreeNode addChild(FunctionTreeNode functionTreeNode) {
        functionTreeNode.setParent(this);
        this.childList.add(functionTreeNode);
        return functionTreeNode;
    }

    public FunctionTreeNode insertChild(FunctionTreeNode functionTreeNode) {
        functionTreeNode.setParent(this);
        this.childList.add(0, functionTreeNode);
        return functionTreeNode;
    }

    public FunctionTreeNode getChild(int n) {
        return this.childList.get(n);
    }

    @Override
    public void removeChild(FunctionTreeNode functionTreeNode) {
        this.childList.remove(functionTreeNode);
    }

    @Override
    public int getChildCount() {
        return this.childList.size();
    }

    @Override
    public int getChildIndex(FunctionTreeNode functionTreeNode) {
        return this.childList.indexOf(functionTreeNode);
    }

    public int getIndex() {
        return 0;
    }

    public String getAnalyseUid() {
        return this.getFunction().getAnalyseUid();
    }

    public BasicAnalyse getAnalyse() {
        return this.getFunction().getAnalyse();
    }

    public BasicAnalyse getAnalyseCatchError() {
        try {
            return this.getAnalyse();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFactorUid() {
        return this.getFunction().getFactorUid(this.getIndex());
    }

    public Factor getFactor() {
        return this.getFunction().getFactor(this.getIndex());
    }

    public Factor getVisualizationFactor() {
        return this.getFunction().getVisualizationFactor(this.getIndex());
    }

    public boolean hasThumbnailResult() {
        return this.getFunction().hasThumbnail(this.getIndex());
    }

    public void addToolTipText(Workflow workflow, StringBuffer stringBuffer) {
    }

    public FunctionTreeNode getRoot() {
        FunctionTreeNode functionTreeNode = this;
        for (FunctionTreeNode functionTreeNode2 = this.getParent(); functionTreeNode2 != null; functionTreeNode2 = functionTreeNode2.getParent()) {
            functionTreeNode = functionTreeNode2;
        }
        return functionTreeNode;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public void setTree(AbstractFunctionTree abstractFunctionTree) {
        this.tree = abstractFunctionTree;
    }

    public AbstractFunctionTree getTree() {
        return this.tree;
    }

    public List<AdditionalFactor> getAdditionalFactors() {
        return null;
    }

    public boolean isFresh() {
        return System.currentTimeMillis() - this.created < 1000L;
    }

    public void delete() {
        BasicAnalyse basicAnalyse = this.getAnalyseCatchError();
        if (basicAnalyse instanceof RtAnalyse) {
            RtAnalyse rtAnalyse = (RtAnalyse)basicAnalyse;
            MembersSetting.delete(rtAnalyse);
        }
    }

    public boolean isVisible() {
        AbstractBreezeFunction abstractBreezeFunction = this.getFunction();
        if (abstractBreezeFunction != null) {
            return abstractBreezeFunction.isVisible(this.getIndex());
        }
        return true;
    }

    public boolean isChildTo(FunctionTreeNode functionTreeNode) {
        if (this.equals(functionTreeNode)) {
            return true;
        }
        for (FunctionTreeNode functionTreeNode2 : this.getChildList()) {
            if (!functionTreeNode2.isChildTo(functionTreeNode)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public Float getLegendMax() {
        return this.legendMax;
    }

    @Generated
    public Float getLegendMin() {
        return this.legendMin;
    }

    @Generated
    public void setLegendMax(Float f) {
        this.legendMax = f;
    }

    @Generated
    public void setLegendMin(Float f) {
        this.legendMin = f;
    }

    public static enum TextType {
        Normal,
        Table,
        TableThumbnail,
        Simple;


        public boolean isTable() {
            return this.equals((Object)Table) || this.equals((Object)TableThumbnail);
        }
    }
}

