/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.frame;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtInterleave;

public class ByteFrame
extends RawFrame
implements Cloneable {
    public final byte[][] origframe;

    public ByteFrame(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames) {
        super(bandCount, pixelWidth, bandNames);
        this.origframe = new byte[bandCount.value][pixelWidth.value];
    }

    @Override
    public ByteFrame copy() {
        ByteFrame byteFrame = new ByteFrame(this.getRows(), this.getColumns(), this.getBandNames());
        for (int i = 0; i < this.rows.value; ++i) {
            System.arraycopy(this.origframe[i], 0, byteFrame.origframe[i], 0, this.columns.value);
        }
        return byteFrame;
    }

    public final void copyFromBuffer(byte[] byArray, RtInterleave rtInterleave, boolean bl, int n) {
        int n2 = n;
        switch (rtInterleave) {
            case BIL: {
                if (bl) {
                    for (int i = 0; i < this.rows.value; ++i) {
                        for (int j = 0; j < this.columns.value; ++j) {
                            this.origframe[i][this.columns.value - j - 1] = byArray[n2++];
                        }
                    }
                } else {
                    for (int i = 0; i < this.rows.value; ++i) {
                        for (int j = 0; j < this.columns.value; ++j) {
                            this.origframe[i][j] = byArray[n2++];
                        }
                    }
                }
                break;
            }
            case BIP: {
                if (bl) {
                    for (int i = 0; i < this.columns.value; ++i) {
                        for (int j = 0; j < this.rows.value; ++j) {
                            this.origframe[j][this.columns.value - i - 1] = byArray[n2++];
                        }
                    }
                } else {
                    for (int i = 0; i < this.columns.value; ++i) {
                        for (int j = 0; j < this.rows.value; ++j) {
                            this.origframe[j][i] = byArray[n2++];
                        }
                    }
                }
                break;
            }
            case BSQ: 
            case BSQ_COL: {
                break;
            }
        }
    }

    @Override
    public final void copyFrameIntoBlock(RtFrame rtFrame, int n, int[] nArray) {
        FloatMatrix floatMatrix = rtFrame.floatMatrix[n];
        int n2 = rtFrame.blockOffset[n];
        for (int i = 0; i < floatMatrix.columns; ++i) {
            int n3;
            int n4 = floatMatrix.rows * i;
            int n5 = i + n2;
            if (nArray != null) {
                for (n3 = 0; n3 < floatMatrix.rows; ++n3) {
                    floatMatrix.data[n4 + n3] = this.origframe[nArray[n3]][n5] & 0xFF;
                }
                continue;
            }
            for (n3 = 0; n3 < floatMatrix.rows; ++n3) {
                floatMatrix.data[n4 + n3] = this.origframe[n3][n5] & 0xFF;
            }
        }
    }

    @Override
    public final void copyFrameBlock(Frame frame, RtFrame rtFrame, int n) {
        FloatMatrix floatMatrix = rtFrame.getMatrix(n);
        int n2 = rtFrame.blockOffset[n];
        for (int i = 0; i < this.rows.value; ++i) {
            System.arraycopy(this.origframe[i], n2, ((ByteFrame)frame).origframe[i], n2, floatMatrix.columns);
        }
    }

    public final int copyFromBufferBSQ(byte[] byArray, int n, int n2) {
        for (int i = 0; i < this.columns.value; ++i) {
            this.setFrameValue(n, i, byArray[n2++]);
        }
        return n2;
    }

    public final byte getFrameValueNative(int n, int n2) {
        return this.origframe[n][n2];
    }

    @Override
    public final float getFrameValue(int n, int n2) {
        return this.origframe[n][n2] & 0xFF;
    }

    @Override
    public final void setFrameValue(int n, int n2, float f) {
        this.origframe[n][n2] = (byte)f;
    }

    @Override
    public DataSize getType() {
        return DataSize.BYTE_1;
    }
}

